@echo off
setlocal enabledelayedexpansion
:start0
:: check if gmt.exe is present
if not exist "%~dps0\resources\gmt.exe" goto :error
if not exist "%~dp0gmapsupp.img" goto :error3

:start
echo Select the desired TYP file:

:: List of .TYP files
echo 0: Wide - standard design for most GPS units with high contrast and wide lines (for medium to high DPI GPS Units) - streets in modern colors only orange to yellow
echo 1: Velo Wide Legacy. Same as above but with streets in high contrast colours - blue/red/orange/yellow)
echo 2: Race - A reduced layout for road cycling/racing with high contrast
echo 3: Velo Layout optimized for small GPS screen - streets in modern colors only orange to yellow
echo 4: Velo_Legacy - Same as above - but with streets in high contrast colours - blue/red/orange/yellow
echo 5: Thin - like Velo Legacy but even thinner lines. For low resolution devices like GPSMaps series.
echo 6: Traditional - the Desktop Layout - lower Contrast not really suited for GPS Units outdoor
echo 7: Wide_Easy - Same width as Wide - but easier to understand - colors similar to topographical maps or google maps. No parallel cycletracks.
echo 8: Fenix --- similar to Velo Wide Legacy but optimized for Fenix series 5/6/7 watches which can only show 64 colours. Not for Fenix 8
echo 9: Topo --- Classical topographical map layout simple and easy to read. High Contrast.
echo 10: LCD-AMOLED --- similar to Wide Legacy but for high DPI devices like Fenix 8 / Epix 2 / Edge 1050 with LCD or AMOLED display (not for Fenix 8 Solar which needs Fenix Layout)
echo X: Exit and leave the current Layout (by default Wide)
echo.



set /p input=Enter your choice (0-10, X):
set input=%input:~0,1%

if /i "%input%"=="0" set TYPfile=velw*.TYP
if /i "%input%"=="1" set TYPfile=vwlg*.TYP
if /i "%input%"=="2" set TYPfile=race*.TYP
if /i "%input%"=="3" set TYPfile=velo*.TYP
if /i "%input%"=="4" set TYPfile=velg*.TYP
if /i "%input%"=="5" set TYPfile=vthn*.TYP
if /i "%input%"=="6" set TYPfile=trdn*.TYP
if /i "%input%"=="7" set TYPfile=esyv*.TYP
if /i "%input%"=="8" set TYPfile=vfnx*.TYP
if /i "%input%"=="9" set TYPfile=topv*.TYP
if /i "%input%"=="10" set TYPfile=vlcd*.TYP
if /i "%input%"=="x" goto :end
if "%TYPfile%"=="" goto :start



:: check if the chosen .TYP file exists
if not exist "%~dps0resources\%TYPfile%" goto :error2

set mapfid=-10

:: find FID of map in dropped/dragged .IMG file
for /f "tokens=5 delims=, " %%G in ('%~dps0resources\gmt.exe -i "%~1"^|findstr /c:", FID "') do set mapfid=%%G
if %mapfid% LEQ 99 goto :gmapsupptest
echo.
echo FID of this map: %mapfid%
echo.
echo.

:: change FID of .TYP file (just to make sure if someone uses another .TYP file via renaming or whatever)
"%~dps0resources/gmt.exe" -w -y %mapfid% "%~dps0resources\%TYPfile%" >NUL

:: replace the .TYP
"%~dps0resources/gmt.exe" -w -x "%~dps0resources\%TYPfile%" "%~1" >NUL

echo.
echo.
echo .TYP file in %~n1%~x1 is replaced by %TYPfile%
goto end

:gmapsupptest
:: find FID of map in dropped/dragged .IMG file
for /f "tokens=5 delims=, " %%G in ('%~dps0resources\gmt.exe -i "%~dp0gmapsupp.img"^|findstr /c:", FID "') do set mapfid=%%G
if %mapfid% LEQ 99 goto :error
echo.
echo FID of this map: %mapfid%
echo.
echo.

:: change FID of .TYP file (just to make sure if someone uses another .TYP file via renaming or whatever)
"%~dps0resources/gmt.exe" -w -y %mapfid% "%~dps0resources\%TYPfile%" >NUL

:: replace the .TYP
"%~dps0resources/gmt.exe" -w -x "%~dps0resources\%TYPfile%" "%~dp0gmapsupp.img" >NUL

echo.
echo.
echo .TYP file in "%~dp0gmapsupp.img" is replaced by %TYPfile%
goto end

:error
echo.
echo.
echo.
echo Requirements:
echo.
echo Change_Layout_velomap.cmd and the gmapsupp.img needs to be in the same folder
echo gmt.exe and the .TYP files need to be in the /resources subfolder
echo.
echo.
echo.
echo Alternative Usage
echo.
echo Drop or Drag the gmapsupp.img file over the Change_Layout_velomap.cmd file
echo and then select the .TYP file you want to use.
echo.
echo.
echo.
pause
goto :start0

:end
echo.
echo.
echo.
echo Change of .TYP File Successful
echo Just move the .gmapsupp to /garmin folder on the mSD card of your Garmin GPS unit
echo.
echo.
echo.
:basecamp_readable
set bscamp=0
@echo.
@echo BASECAMP VISIBILITY
@echo - do you want that the gmapsupp.img file to show up in Basecamp?
@echo - note that reading in the map by Basecamp takes some time. Therefore it is off by default now. 
@echo - However it can be useful to some.
@echo - Press 0 or any other key to keep map invisible to Basecamp. Press 1 to make map readable by Basecamp
set /p bscamp=0-1:
@echo.
@echo.
if 1 EQU %bscamp% echo Map will be read in by basecamp.
if 1 EQU %bscamp% set bscampx=0
if 1 NEQ %bscamp% set bscampx=1
if 1 NEQ %bscamp% echo Map will not be read in by basecamp.
"%~dps0resources/gmt.exe" -wc 1.00,%bscampx% "%~dp0gmapsupp.img" >NUL
@echo.
@echo.
if 1 EQU %bscamp% timeout 6 >NUL
if 1 NEQ %bscamp% timeout 3 >NUL
exit

:error2
echo.
echo.
echo.
echo Cannot Find the chosen .TYP file.
echo You need to have the selected .TYP file in the resources folder.
echo.
echo.
echo.
echo.
echo.
echo General Requirements:
echo.
echo Change_Layout_velomap.cmd and the gmapsupp.img needs to be in the same folder
echo gmt.exe and the .TYP files need to be in the /resources subfolder
echo.
echo.
echo.
pause
goto :start0

:error3
set str1="%~1"
if not x%str1:.img=%==x%str1% goto :start
if x%str1:.img=%==x%str1% goto :error
echo on
echo something went wrong here - please contact Felix on openmtbmap.org
pause
exit
