#!/bin/bash
# set -x #echo on

#=====================================================================
#
# This .bash file is copyrighted by https://openmtbmap.org.
# You may not (re)distribute it.
# gmaptool (gmt) is published by www.gmaptool.eu. 
# Only for OpenMTBMap and VeloMap gmap format country contourlins maps.
# Not compatible with new Mac OSx version only supporting 64bit (gmt is only available as 32bit program on Mac, no problem in Linux - so use a virtual machine with linux or another PC if you need it)


echo "please press "0" for 20m (7*.img) contourlines"
echo "please press "1" for 10m (9*.img) contourlines" 
echo "please press "2" for 10m resolution 23 (8*.img) contourlines"
read input
if [ "$input" == "0" ]; then
	cntrs=7*
elif [ "$input" == "O" ]; then
	cntrs=7*
elif [ "$input" == "o" ]; then
	cntrs=7*
elif [ "$input" == "1" ]; then
	cntrs=9*
elif [ "$input" == "2" ]; then
	cntrs=8*
else
	echo "You pressed a wrong key. Will exit now."
	exit
fi	


FOUND=
cd ./Product1
for DIR in $cntrs
do
        if [ -d "$DIR" ]; then
			break
        else
			echo "Error: Cannot find any OpeMTBMap or VeloMap Contourlines!"
			echo "Aborting Now"
			exit
		fi
done
#Contourline Map Folders in product1 found. Asking for Confirmation then Renaming all *.DEM files to *.DEM.old

if [[ $(find . -name "*.DEM.old") ]]; then
	# DEM.old files found. So let's remove all DEM.old files to DEM.
	echo "Found backup .DEM.old files"
	echo "They .DEM.old files will be renamed to .DEM so that your map shows relief shading again plus DEM information"
	echo ""
	echo "Press any key to continue"
	read -n 1 -s -r -p  "Close the Terminal or press CTRL-C to exit now"
	echo ""
	echo ""
	find . -name "*.DEM.old" -exec bash -c 'mv "$1" "${1%.DEM.old}".DEM' - '{}' \;
	if [ $? -eq 0 ]; then
		echo "Success - Removed the DEM information from all .DEM contourlines files"
		echo ""
		echo ""
	else
		echo "Error - likely could not rename the .DEM.old files. Make sure that those files are not open anywhere. Make sure Basecamp is closed!"
		echo ""
		echo ""
	fi
	exit
	
elif [[ $(find . -name "*.DEM") ]]; then
    # No DEM.old files found. So let's remove all DEM files to DEM.old
	echo "This script will Remove the DEM information from the contourlines"
	echo "They .DEM files will be renamed to .DEM.old so they can be re-enabled"
	echo ""
	echo "Press any key to continue"
	read -n 1 -s -r -p  "Close the Terminal or press CTRL-C to exit now"
	echo ""
	echo ""
	find . -name "*.DEM" -exec bash -c 'mv "$1" "${1%.DEM}".DEM.old' - '{}' \;
	if [ $? -eq 0 ]; then
		echo "Success - Removed the DEM information from all .DEM contourlines files"
		echo ""
		echo ""
	else
		echo "Error - likely could not rename the .DEM files. Make sure that the map is not open anywhere"
		echo ""
		echo ""
		echo "Ending Now"
		exit
	fi

	if [[ $(find . -name "*.DEM.old") ]]; then
		echo "You can now optionally remove the old contourlines containing DEM. Attention you cannot restore them anymore once deleted"
		echo "If you remove the old contourlines and want to reenable DEM - you will need to redownload the map or contourlines"
		echo ""
		echo "Type yes to continue - Press any key or type no to stop (yes/no):"
		read input
		if [ "$input" == "yes" ]; then
			find . -name "*.DEM.old" -type f -delete
			echo "Removed all *.DEM.old files. To restore the DEM data please redownload the Contourlines of this Map or the full Map including contourlines"
		else
			echo "Keeping the DEM information as DEM.old files. Exiting Now"
		fi
	fi
	
else
	echo "Found $cntrs contourlines folder in Product1 folder"
	echo "But did not find any *.DEM files"
	echo ""
	echo "This map does not contain DEM information. Maybe your removed the DEM information already"
fi
exit
