/////////////////////////////////////////////////////////////////////
////                                                             ////
////  NORM_MUL                                                   ////
////  Normalization Unit for Multiply (Single precision)         ////
////                                                             ////
////  Author: Rudolf Usselmann                                   ////
////          russelmann@hotmail.com                             ////
////                                                             ////
/////////////////////////////////////////////////////////////////////
////                                                             ////
//// Copyright (C) 2000 Rudolf Usselmann                         ////
////                    russelmann@hotmail.com                   ////
////                                                             ////
//// This source file may be used and distributed without        ////
//// restriction provided that this copyright statement is not   ////
//// removed from the file and that any derivative work contains ////
//// the original copyright notice and the associated disclaimer.////
////                                                             ////
//// THIS SOURCE FILE IS PROVIDED "AS IS" AND WITHOUT ANY        ////
//// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT           ////
//// LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND   ////
//// FITNESS FOR A PARTICULAR PURPOSE.                           ////
////                                                             ////
/////////////////////////////////////////////////////////////////////


`timescale 1ns / 10ps

module norm_mul( clk, fract_in, exp_in, out);
input		clk;
input	[47:0]	fract_in;
input	[7:0]	exp_in;
output	[30:0]	out;

////////////////////////////////////////////////////////////////////////
//
// Local Wires and registers
//

reg	[6:0]	exp_adj;
reg	[22:0]	fract_out;
wire	[7:0]	exp_out;
wire	[30:0]	out;

////////////////////////////////////////////////////////////////////////
//
// Normalize Result
//

// Count Number of zeros in fract_in from msb to lsb and adjust
// output so there are no leading zeros

always @(fract_in)
   casex(fract_in)	// synopsys full_case parallel_case
	48'b1???????????????????????????????????????????????: fract_out = fract_in[46:24];
	48'b01??????????????????????????????????????????????: fract_out = fract_in[45:23];
	48'b001?????????????????????????????????????????????: fract_out = fract_in[44:22];
	48'b0001????????????????????????????????????????????: fract_out = fract_in[43:21];
	48'b00001???????????????????????????????????????????: fract_out = fract_in[42:20];
	48'b000001??????????????????????????????????????????: fract_out = fract_in[41:19];
	48'b0000001?????????????????????????????????????????: fract_out = fract_in[40:18];
	48'b00000001????????????????????????????????????????: fract_out = fract_in[39:17];
	48'b000000001???????????????????????????????????????: fract_out = fract_in[38:16];
	48'b0000000001??????????????????????????????????????: fract_out = fract_in[37:15];
	48'b00000000001?????????????????????????????????????: fract_out = fract_in[36:14];
	48'b000000000001????????????????????????????????????: fract_out = fract_in[35:13];
	48'b0000000000001???????????????????????????????????: fract_out = fract_in[34:12];
	48'b00000000000001??????????????????????????????????: fract_out = fract_in[33:11];
	48'b000000000000001?????????????????????????????????: fract_out = fract_in[32:10];
	48'b0000000000000001????????????????????????????????: fract_out = fract_in[31:9];
	48'b00000000000000001???????????????????????????????: fract_out = fract_in[30:8];
	48'b000000000000000001??????????????????????????????: fract_out = fract_in[29:7];
	48'b0000000000000000001?????????????????????????????: fract_out = fract_in[28:6];
	48'b00000000000000000001????????????????????????????: fract_out = fract_in[27:5];
	48'b000000000000000000001???????????????????????????: fract_out = fract_in[26:4];
	48'b0000000000000000000001??????????????????????????: fract_out = fract_in[25:3];
	48'b00000000000000000000001?????????????????????????: fract_out = fract_in[24:2];
	48'b000000000000000000000001????????????????????????: fract_out = fract_in[23:1];
	48'b0000000000000000000000001???????????????????????: fract_out = fract_in[22:0];
	48'b00000000000000000000000001??????????????????????: fract_out = { fract_in[21:0], 1'h0 };
	48'b000000000000000000000000001?????????????????????: fract_out = { fract_in[20:0], 2'h0 };
	48'b0000000000000000000000000001????????????????????: fract_out = { fract_in[19:0], 3'h0 };
	48'b00000000000000000000000000001???????????????????: fract_out = { fract_in[18:0], 4'h0 };
	48'b000000000000000000000000000001??????????????????: fract_out = { fract_in[17:0], 5'h0 };
	48'b0000000000000000000000000000001?????????????????: fract_out = { fract_in[16:0], 6'h0 };
	48'b00000000000000000000000000000001????????????????: fract_out = { fract_in[15:0], 7'h0 };
	48'b000000000000000000000000000000001???????????????: fract_out = { fract_in[14:0], 8'h0 };
	48'b0000000000000000000000000000000001??????????????: fract_out = { fract_in[13:0], 9'h0 };
	48'b00000000000000000000000000000000001?????????????: fract_out = { fract_in[12:0], 10'h0 };
	48'b000000000000000000000000000000000001????????????: fract_out = { fract_in[11:0], 11'h0 };
	48'b0000000000000000000000000000000000001???????????: fract_out = { fract_in[10:0], 12'h0 };
	48'b00000000000000000000000000000000000001??????????: fract_out = { fract_in[9:0], 13'h0 };
	48'b000000000000000000000000000000000000001?????????: fract_out = { fract_in[8:0], 14'h0 };
	48'b0000000000000000000000000000000000000001????????: fract_out = { fract_in[7:0], 15'h0 };
	48'b00000000000000000000000000000000000000001???????: fract_out = { fract_in[6:0], 16'h0 };
	48'b000000000000000000000000000000000000000001??????: fract_out = { fract_in[5:0], 17'h0 };
	48'b0000000000000000000000000000000000000000001?????: fract_out = { fract_in[4:0], 18'h0 };
	48'b00000000000000000000000000000000000000000001????: fract_out = { fract_in[3:0], 19'h0 };
	48'b000000000000000000000000000000000000000000001???: fract_out = { fract_in[2:0], 20'h0 };
	48'b0000000000000000000000000000000000000000000001??: fract_out = { fract_in[1:0], 21'h0 };
	48'b00000000000000000000000000000000000000000000001?: fract_out = { fract_in[000], 22'h0 };
	48'b000000000000000000000000000000000000000000000001: fract_out = 23'h0;
   endcase

// Determine how much to add to exp_out
always @(fract_in)
   casex(fract_in)	// synopsys full_case parallel_case
	48'b1???????????????????????????????????????????????: exp_adj =   1;
	48'b01??????????????????????????????????????????????: exp_adj =   0;
	48'b001?????????????????????????????????????????????: exp_adj =  -1;
	48'b0001????????????????????????????????????????????: exp_adj =  -2;
	48'b00001???????????????????????????????????????????: exp_adj =  -3;
	48'b000001??????????????????????????????????????????: exp_adj =  -4;
	48'b0000001?????????????????????????????????????????: exp_adj =  -5;
	48'b00000001????????????????????????????????????????: exp_adj =  -6;
	48'b000000001???????????????????????????????????????: exp_adj =  -7;
	48'b0000000001??????????????????????????????????????: exp_adj =  -8;
	48'b00000000001?????????????????????????????????????: exp_adj =  -9;
	48'b000000000001????????????????????????????????????: exp_adj =  -10;
	48'b0000000000001???????????????????????????????????: exp_adj =  -11;
	48'b00000000000001??????????????????????????????????: exp_adj =  -12;
	48'b000000000000001?????????????????????????????????: exp_adj =  -13;
	48'b0000000000000001????????????????????????????????: exp_adj =  -14;
	48'b00000000000000001???????????????????????????????: exp_adj =  -15;
	48'b000000000000000001??????????????????????????????: exp_adj =  -16;
	48'b0000000000000000001?????????????????????????????: exp_adj =  -17;
	48'b00000000000000000001????????????????????????????: exp_adj =  -18;
	48'b000000000000000000001???????????????????????????: exp_adj =  -19;
	48'b0000000000000000000001??????????????????????????: exp_adj =  -20;
	48'b00000000000000000000001?????????????????????????: exp_adj =  -21;
	48'b000000000000000000000001????????????????????????: exp_adj =  -22;
	48'b0000000000000000000000001???????????????????????: exp_adj =  -23;
	48'b00000000000000000000000001??????????????????????: exp_adj =  -24;
	48'b000000000000000000000000001?????????????????????: exp_adj =  -25;
	48'b0000000000000000000000000001????????????????????: exp_adj =  -26;
	48'b00000000000000000000000000001???????????????????: exp_adj =  -27;
	48'b000000000000000000000000000001??????????????????: exp_adj =  -28;
	48'b0000000000000000000000000000001?????????????????: exp_adj =  -29;
	48'b00000000000000000000000000000001????????????????: exp_adj =  -30;
	48'b000000000000000000000000000000001???????????????: exp_adj =  -31;
	48'b0000000000000000000000000000000001??????????????: exp_adj =  -32;
	48'b00000000000000000000000000000000001?????????????: exp_adj =  -33;
	48'b000000000000000000000000000000000001????????????: exp_adj =  -34;
	48'b0000000000000000000000000000000000001???????????: exp_adj =  -35;
	48'b00000000000000000000000000000000000001??????????: exp_adj =  -36;
	48'b000000000000000000000000000000000000001?????????: exp_adj =  -37;
	48'b0000000000000000000000000000000000000001????????: exp_adj =  -38;
	48'b00000000000000000000000000000000000000001???????: exp_adj =  -39;
	48'b000000000000000000000000000000000000000001??????: exp_adj =  -40;
	48'b0000000000000000000000000000000000000000001?????: exp_adj =  -41;
	48'b00000000000000000000000000000000000000000001????: exp_adj =  -42;
	48'b000000000000000000000000000000000000000000001???: exp_adj =  -43;
	48'b0000000000000000000000000000000000000000000001??: exp_adj =  -44;
	48'b00000000000000000000000000000000000000000000001?: exp_adj =  -45;
	48'b000000000000000000000000000000000000000000000001: exp_adj =  -46;
	48'b000000000000000000000000000000000000000000000000: exp_adj =  0;
   endcase

assign exp_out = exp_in + {exp_adj[6], exp_adj};

assign out = {exp_out[7:0], fract_out};

endmodule

