--==========================================================================--
-- Design units : 10/100 Ethernet MAC - RxMAC - RxDataRegister
--
-- File name    : rxdataregister.vhd
--
-- Purpose      : For frame processing it is necessary to latch the received
--                nibbles in a register to generate a synchronous RxValid
--                signal for CRC checking and length counting.
--
-- Note         : None
--
-- Limitations  : None
--
-- Errors       : None known
--
-- Library      : EthMAC_Lib
--
-- Dependencies : None
--
-- Author       : Maik Boden (boden@ite.inf.tu-dresden.de)
--                Dresden University of Technology
--                Department of Information Science
--                Institute of Computer Engineering
--
-- Simulator    : VHDL Simili 1.4 Beta, Windows NT 4.0
------------------------------------------------------------------------------
-- Revision list
-- Version  Author  Date        Changes
-- 0.1      MB      2000-09-04  Initial revision
--==========================================================================--

library IEEE;
use IEEE.Std_Logic_1164.all;

entity RxDataRegister is
  port(
    -- Receive clock and asynchronous reset
    RxReset_N:   in  Std_ULogic;
    RxClk:       in  Std_ULogic;
    -- Receive signals from RxSyncFIFO
    RxFifoD:     in  Std_ULogic_Vector(3 downto 0);
    RxFifoDV:    in  Std_ULogic;
    -- Receive data for host system
    RxData:      out Std_ULogic_Vector(3 downto 0);
    RxDataValid: out Std_ULogic
  );
end RxDataRegister;

--==========================================================================--

library IEEE;
use IEEE.Std_Logic_1164.all;

architecture RTL of RxDataRegister is

begin  -- Architecture RTL of RxDataRegister

  ----------------------------------------------------------------------------
  -- At the rising edge of RxClk the FIFO output is latched into the register.
  ----------------------------------------------------------------------------
  LatchInput: process (RxReset_N, RxClk)
  begin
    if RxReset_N = '0' then
      RxData      <= (others => '0');
      RxDataValid <= '0';
    elsif Rising_Edge(RxClk) then
      RxData      <= RxFifoD;
      RxDataValid <= RxFifoDV;
    end if;
  end process LatchInput;

end RTL;  -- End of RxDataRegister (RTL)
