/*************************************************************************\
*                                                                         *
*    File    : tx_var.v                                                   *
*    Purpose : Variable Definition of Tx Eth MAC modules                  *
*    Author  : Novan Hartadi (novan@vlsi.itb.ac.id)                       *
*                                                                         *
\*************************************************************************/

//for simulation only
`timescale 1ns/10ps
`define UD 0

//FIFO Synchronization
`define WIDTH_FIFO 4

//Backoff Timer
`define SLOT_TIME    (17'd128)
`define BACKOFF_IDLE (2'b00)
`define BACKOFF_RUN  (2'b01)
`define BACKOFF_MAX  (2'b11)

//CRC Generator
`define CRC_RESET_VALUE (32'h0000_0000)
`define CRC_INIT_VALUE  (32'hFFFF_FFFF)
`define CRC_IDLE        (2'b00)
`define CRC_FIRST       (2'b01)
`define CRC_RUN         (2'b11)
`define CRC_STOP        (2'b10)

//Data Multiplexer
`define PATTERN_PREAMBLE (4'b0101)
`define PATTERN_SFD      (4'b1101)

//Defer Counter
`define MAX_DEFER  (13'd6072)
`define DEFER_IDLE (2'b00)
`define DEFER_RUN  (2'b01)
`define DEFER_MAX  (2'b11)

//Frame Length Counter
`define COUNT_LENGTH_IDLE (2'b00)
`define COUNT_LENGTH_RUN  (2'b01)
`define COUNT_LENGTH_FCS  (2'b11)
`define MIN_LENGTH        (12'd144)
`define MAX_LENGTH        (12'd3052)

//IFG Timer
`define IFG_LENGTH_1 (5'd15)
`define IFG_LENGTH_2 (5'd23)
`define IFG_IDLE     (2'b00)
`define IFG_RUN      (2'b01)
`define IFG_MAX      (2'b11)

//JAM Timer
`define JAM_IDLE (1'b0)
`define JAM_RUN  (1'b1)

//Collision Counter
`define MAX_COLLISION (4'd15)
`define COLL_IDLE     (2'b00)
`define COLL_RESTART  (2'b01)
`define COLL_EVENT    (2'b11)
`define COLL_JAM      (2'b10)

//Tx State Machine
`define TRANSMIT_IDLE     (4'b0000)
`define NEW_TRANSMIT      (4'b0001)
`define WAIT_TRANSMIT     (4'b0011)
`define TRANSMIT_PREAMBLE (4'b0010)
`define TRANSMIT_SFD      (4'b0110)
`define TRANSMIT_DATA     (4'b0111)
`define TRANSMIT_DATAEND1 (4'b0101)
`define TRANSMIT_DATAEND2 (4'b0100)
`define TRANSMIT_PAD      (4'b1100)
`define TRANSMIT_FCS      (4'b1101)
`define WAIT_DONE         (4'b1111)
`define TRANSMIT_DONE     (4'b1110)
`define TRANSMIT_JAM      (4'b1010)
`define WAIT_BACKOFF      (4'b1011)
`define TRANSMIT_ABORT    (4'b1001)
`define WRITE_STATUS      (4'b1000)

`define PREAMBLE_LENGTH (12'd15)
`define SFD_LENGTH      (12'd1)
`define DATA_LENGTH     (12'd120)
`define FCS_LENGTH      (4'd8)
`define JAM_LENGTH      (4'd8)
