/*************************************************************************\
*                                                                         *
*    File      : test_tx_ethmac_coll.v                                    *
*    Purpose   : Testbench for Tx Eth MAC                                 *
*    Author    : Novan Hartadi (novan@vlsi.itb.ac.id)                     *
*    Simulator : ModelSim PE/Plus 4.7h                                    *
*                                                                         *
\*************************************************************************/

module test_tx_ethmac_coll();

reg [3:0] tx_data;
reg tx_sof;
reg tx_eof;
reg tx_underrun;
reg full_duplex; 
reg reset_n;
reg crs;
reg coll;
reg tx_clk;

wire [3:0] txd;
wire tx_en;
wire tx_er;
wire tx_data_used;
wire tx_done;
wire tx_abort;
wire tx_retransmit;
wire [6:0] tx_status;
wire tx_status_valid_n;

tx_ethmac test (
  tx_data,
  tx_sof,
  tx_eof,
  tx_underrun,
  full_duplex,
  reset_n,
  crs,
  coll,
  tx_clk,
  tx_data_used,
  tx_done,
  tx_abort,
  tx_retransmit,
  tx_status,
  tx_status_valid_n,
  txd,
  tx_en,
  tx_er
  );
  
initial
begin
  tx_clk = 1;
  #5300 $finish;
end

always #5 tx_clk = ~ tx_clk;

initial
begin
  reset_n = 1;
  #5 reset_n = 0;
  #5 reset_n = 1;
end

initial
begin
  tx_sof = 0;
  tx_eof = 0;
  tx_underrun = 0;
  full_duplex = 0; 
  #100 tx_sof = 1;
  #500 tx_sof = 0;
  #500 tx_sof = 1;
  #1470 tx_sof = 0;
  #2220 tx_eof = 1;
  #10 tx_eof = 0;
end

initial
begin
  coll = 0;
  #1000 coll = 1;
  #100 coll = 0;
end

initial
begin
  tx_data = 0;
  #100 tx_data = 8;
  #4700 tx_data = 0;
end
  
initial
begin
  crs = 1;
  #200 crs = 0;
  #240 crs = 1;
  #660 crs = 0;
  #1310 crs = 1;
  #2480 crs = 0;
end

endmodule
