/*************************************************************************\
*                                                                         *
*    File    : jam_timer.v                                                *
*    Purpose : JAM Timer Module                                           *
*    Author  : Novan Hartadi (novan@vlsi.itb.ac.id)                       *
*                                                                         *
/*************************************************************************\

/*************************************************************************\
*                                                                         *
*    Brief Description :                                                  *
*                                                                         *
*    The function of this module is to determine how long JAM pattern     *
*    has been transmitted after a collision. The JAM counter will count   *
*    after coll_event_p is detected.                                      *
*                                                                         *
\*************************************************************************/

`include "tx_var.v"

module jam_timer (
  coll_event_p,
  clk,
  reset_n,
  count_jam
  );

input coll_event_p;
input clk;
input reset_n;
output [3:0] count_jam;

reg [3:0] count_jam;
reg state_jam;

always @(posedge clk or negedge reset_n)
  if (reset_n == 1'b0)
    state_jam <= #`UD `JAM_IDLE;
  else
    case (state_jam)
      `JAM_IDLE : if (coll_event_p == 1'b1)
                  begin
                    count_jam <= #`UD 4'd1;
                    state_jam <= #`UD `JAM_RUN;
                  end
                  else
                    count_jam <= #`UD 4'd0;
      `JAM_RUN  : if ( count_jam == (`JAM_LENGTH) )
                    state_jam <= #`UD `JAM_IDLE;
                  else
                    count_jam <= #`UD (count_jam + 1'b1);
    endcase

endmodule