/*************************************************************************\
*                                                                         *
*    File    : fifo_synch.v                                               *
*    Purpose : FIFO Synchronization Module                                *
*    Author  : Novan Hartadi (novan@vlsi.itb.ac.id)                       *
*                                                                         *
/*************************************************************************\

/*************************************************************************\
*                                                                         *
*    Brief Description :                                                  *
*                                                                         *
*    The function of this module is to keep synchronization all outputs   *
*    with the rising edge of input clock. FIFO will transmit a valid data *
*    nibble output if transmit_enable is asserted.                        *
*    When transmit_enable is asserted, tx_en will be asserted. If         *
*    transmit_error is asserted tx_er will be asserted too.               *
*                                                                         *
\*************************************************************************/

`include "tx_var.v"

module fifo_synch (
  data,
  transmit_enable,
  transmit_error,
  clk,
  reset_n,
  txd,
  tx_en,
  tx_er
  );

input [`WIDTH_FIFO-1:0] data;
input transmit_enable;
input transmit_error;
input clk;
input reset_n;
output [`WIDTH_FIFO-1:0] txd;
output tx_en;
output tx_er;

reg [`WIDTH_FIFO-1:0] txd;
reg tx_en;
reg tx_er;

always @(posedge clk or negedge reset_n)
  if (reset_n == 1'b0)
  begin
    txd <= #`UD 4'h0;
    tx_en <= #`UD 1'b0;
    tx_er <= #`UD 1'b0;
    end
  else
  if (transmit_enable == 1'b1)
  begin
    txd <= #`UD data;
    tx_en <= #`UD transmit_enable;
    tx_er <= #`UD transmit_error;
  end
  else
  begin
    txd <= #`UD 4'h0;
    tx_en <= #`UD 1'b0;
    tx_er <= #`UD 1'b0;
  end

endmodule
