/*************************************************************************\
*                                                                         *
*    File        : dff_tx.v                                               *
*    Description : D Flip-Flop Module with active low reset               *
*                                                                         *
\*************************************************************************/

`include "tx_var.v"

module dff_tx (
  d,
  clk,
  reset_n,
  q
  );

parameter  WIDTH_DFF = 1;

input [WIDTH_DFF-1:0] d;
input clk;
input reset_n;
output [WIDTH_DFF-1:0] q;

reg [WIDTH_DFF-1:0] q;

always @(posedge clk or negedge reset_n)
  if (reset_n == 1'b0)
    q <= #`UD 0;
  else 
    q <= #`UD d;

endmodule