/*************************************************************************\
*                                                                         *
*    File    : data_mux.v                                                 *
*    Purpose : Data Multiplexer Module                                    *
*    Author  : Novan Hartadi (novan@vlsi.itb.ac.id)                       *
*                                                                         *
/*************************************************************************\

/*************************************************************************\
*                                                                         *
*    Brief Description :                                                  *
*                                                                         *
*    The function of this module is to determine which data nibbles will  *
*    be transmitted to MII, which are related to data_select signal from  *
*    state machine. Data nibble 4'b0101 is pattern for Preamble, JAM, and *
*    PAD. While data nibble 4'b1101 is pattern for SFD.                   *
*                                                                         *
\*************************************************************************/

`include "tx_var.v"

module data_mux (
  data_select,
  tx_data,
  crc,
  data
  );

input [1:0] data_select;
input [3:0] tx_data;
input [0:3] crc;
output [3:0] data;

reg [3:0] data;

always @(data_select or tx_data or crc)
  case (data_select)
    2'b00   : data = tx_data;
    2'b01   : data = `PATTERN_PREAMBLE;  //pattern for preamble, jam, and pad
    2'b10   : data = `PATTERN_SFD;
    2'b11   : data = crc;
    default : data = 4'h0;
  endcase

endmodule
