-- Sayuri GNU Public Licence 32 bit CPU design/implementation
-- Sayuri 32 bit RISC
-- Copyright (C) 2000 Toyoaki Sagawa.
-- This program/design/implementation is a free software/hardware design 
-- (and all intellectual property therein); you can redistribute it and/or
-- modify it under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2
-- of the License, or (at your option) any later version.
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
-- GNU General Public License for more details.
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
-- USA.
-- Toyoaki Sagawa,
-- PXW07530@nifty.ne.jp
-- http://www.morphyplanning.co.jp/FreeCPU/freecpu-e.html
-- Postal 113-0034 Yusima, 4-11-16-808 Bunkyo, Tokyo, Japan

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity TEST_CPU is
end TEST_CPU;

architecture SIM1 of TEST_CPU is

component CPU 
    port (
	DMEMAO: out STD_LOGIC_VECTOR (31 downto 0);
	DMEMDIN: in STD_LOGIC_VECTOR (31 downto 0);
	DMEMDOUT: out STD_LOGIC_VECTOR (31 downto 0);
	IMEMAO: out STD_LOGIC_VECTOR (31 downto 0);
	IMEMDIN: in STD_LOGIC_VECTOR (31 downto 0);
	CLK, RESET: in STD_LOGIC;
	MEMWE : out STD_LOGIC;
	MEMOE : out STD_LOGIC;
	INTIN : in STD_LOGIC;
	MODEOUT : out STD_LOGIC;
	WAITIN : in STD_LOGIC
    );
end component;
component SRAM
	generic( AW : integer;
		     DW : integer  );
	port( nWR, nRD, nCS : in std_logic;
	  	ADR : in std_logic_vector(AW-1 downto 0);
		DIN : in std_logic_vector(DW-1 downto 0);
		DOUT : out std_logic_vector(DW-1 downto 0)
	);
end component;
component ROM
	generic( AW : integer;
		     DW : integer  );
	port( nRD, nCS : in std_logic;
	  	ADR : in std_logic_vector(AW-1 downto 0);
		DOUT : out std_logic_vector(DW-1 downto 0)
	);
end component;
component CHIPSEL 
    port (
	DMEMADD: in STD_LOGIC_VECTOR (31 downto 0);
	IMEMADD: in STD_LOGIC_VECTOR (31 downto 0);
        nDMEMCS,nIMEMCS: out STD_LOGIC
    );
end component;

constant CLK_CYCLE : Time := 20 ns;

signal  CLK,nRESET ,nDMEMCS,nIMEMCS,MEMWE,MEMOE, nRD: STD_LOGIC;
signal  DMEMDIN, IMEMDIN, DMEMDOUT, DMEMADD, IMEMADD: STD_LOGIC_VECTOR(31 downto 0);
signal intin, modeout, waitin: STD_LOGIC;

begin
 U0 : CPU port map(DMEMAO=>DMEMADD, DMEMDIN=>DMEMDIN, DMEMDOUT=>DMEMDOUT,IMEMAO=>IMEMADD,
        IMEMDIN=>IMEMDIN, CLK=>CLK,RESET=>nRESET,MEMWE=>MEMWE,MEMOE=>MEMOE, intin=>intin, modeout=>modeout, waitin=>waitin);
 U1 : ROM generic map (AW=>8, DW=>32)
		port map(nRD=>nRD, nCS=>nIMEMCS, DOUT=>IMEMDIN, ADR=>IMEMADD(7 downto 0));
 U2 : SRAM generic map (AW=>8, DW=>32)
		port map(nRD=>MEMOE, nWR=>MEMWE, nCS=>nDMEMCS, DIN=>DMEMDOUT, DOUT=>DMEMDIN, ADR=>DMEMADD(7 downto 0));
 U3 : CHIPSEL port map(DMEMADD=>DMEMADD, IMEMADD=>IMEMADD, nDMEMCS=>nDMEMCS, nIMEMCS=>nIMEMCS);

	process begin
	for I in 0 to 400 loop
		CLK <= '1';
		wait for CLK_CYCLE /2;
		CLK <= '0';
		wait for CLK_CYCLE /2;
	end loop;
	wait;
	end process;

	process begin
		nRESET <= '0';
		intin <= '0';
		waitin <= '0';
		nRD <= '0';
		wait for 2 ns;
		nRESET <= '1';
		wait for CLK_CYCLE*60;
		intin <= '1';
		wait for CLK_CYCLE*6;
		intin <= '0';
		wait for CLK_CYCLE*100;

	end process;

end SIM1;








