-- Sayuri GNU Public Licence 32 bit CPU design/implementation
-- Sayuri 32 bit RISC
-- Copyright (C) 2000 Toyoaki Sagawa.
-- This program/design/implementation is a free software/hardware design 
-- (and all intellectual property therein); you can redistribute it and/or
-- modify it under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2
-- of the License, or (at your option) any later version.
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
-- GNU General Public License for more details.
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
-- USA.
-- Toyoaki Sagawa,
-- PXW07530@nifty.ne.jp
-- http://www.morphyplanning.co.jp/FreeCPU/freecpu-e.html
-- Postal 113-0034 Yusima, 4-11-16-808 Bunkyo, Tokyo, Japan


-- 
-- Sayuri Register module
-- 2000/08/16 Rev.1.0 Toyozou
-- 
-- very large. do not use it in real device!
-- 32 bit X 32 Word = 1024 bit
-- 

library IEEE;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_1164.all;

entity REG is
	port(   CLK : in std_logic;
		WE : in std_logic_vector(31 downto 0);
		OE : in std_logic_vector(31 downto 0);
		DIN : in std_logic_vector(31 downto 0);
		DOUT : out std_logic_vector(31 downto 0)
	);
end REG;

architecture RTL of REG is

subtype REGWORD is std_logic_vector(31 downto 0);
type REGARRAY is array ( 0 to 31) of REGWORD;

signal REGDATA : REGARRAY;
	constant ALLZERO : std_logic_vector(31 downto 0) := "00000000000000000000000000000000";
begin
	process(OE, REGDATA) begin
	if(OE = ALLZERO) then
		DOUT <= (others => '0');
	else
		for i in OE'range loop
			if(OE(I) = '1')then
				DOUT <= REGDATA(I);
			end if;
		end loop;
	end if;
	end process;

	process (CLK) begin
		if (CLK'event and CLK = '1') then
		for I in WE'range loop
			if(WE(I) = '1')then
				REGDATA(I) <= DIN;
			end if;
		end loop;
		end if;
	end process;
end RTL;




