-- Sayuri GNU Public Licence 32 bit CPU design/implementation
-- Sayuri 32 bit RISC
-- Copyright (C) 2000 Toyoaki Sagawa.
-- This program/design/implementation is a free software/hardware design 
-- (and all intellectual property therein); you can redistribute it and/or
-- modify it under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2
-- of the License, or (at your option) any later version.
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
-- GNU General Public License for more details.
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
-- USA.
-- Toyoaki Sagawa,
-- PXW07530@nifty.ne.jp
-- http://www.morphyplanning.co.jp/FreeCPU/freecpu-e.html
-- Postal 113-0034 Yusima, 4-11-16-808 Bunkyo, Tokyo, Japan

-- 
-- Sayuri Logic module
-- 2000/08/14 Rev.1.0 Toyozou
-- 
-- 8/20 change 1 base reg & 1 output reg

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_arith.all;

entity LOG is
    port (
        DIN: in STD_LOGIC_VECTOR (31 downto 0);
        DOUT: out STD_LOGIC_VECTOR (31 downto 0);
        CLK: in STD_LOGIC;
        WE: in STD_LOGIC_VECTOR (7 downto 0);
        OE: in STD_LOGIC_VECTOR(1 downto 0)
    );
end LOG;

architecture LOG_arch of LOG is
	signal OUTREG: std_logic_vector(31 downto 0);
	signal REGA : std_logic_vector(31 downto 0);
begin

  process(OE, OUTREG) begin
	case OE is
		when "01" => -- BASE REG
			DOUT <= REGA;
		when "10" => -- OUTPUT REG
			DOUT <= OUTREG;
		when others => DOUT <= (others => '0');
	end case;
  end process;

  process (CLK) begin
   if (CLK'event and CLK='1') then
	case WE is
	when "00000001" => -- BASE REG
		OUTREG <= OUTREG;
		REGA <= DIN;
	when "00000010" => -- OUTPUT REG
		OUTREG <= DIN;
		REGA <= REGA;
	when "00000100" =>  -- NOT
		OUTREG <= not DIN;
		REGA <= REGA;
	when "00001000" =>  -- OR
		OUTREG <= REGA or DIN;
		REGA <= REGA;
	when "00010000" =>  -- AND
		OUTREG <= REGA and DIN;
		REGA <= REGA;
	when "00100000" =>  -- NAND
		OUTREG <= REGA nand DIN;
		REGA <= REGA;
	when "01000000" =>  -- EXOR
		OUTREG <= REGA xor DIN;
		REGA <= REGA;
	when "10000000" =>  -- NOR
		OUTREG <= REGA nor DIN;
		REGA <= REGA;
	when others => 
		OUTREG <= OUTREG;
		REGA <= REGA;
	end case;	
   end if;
  end process;
  
end LOG_arch;






