-- Sayuri GNU Public Licence 32 bit CPU design/implementation
-- Sayuri 32 bit RISC
-- Copyright (C) 2000 Toyoaki Sagawa.
-- This program/design/implementation is a free software/hardware design 
-- (and all intellectual property therein); you can redistribute it and/or
-- modify it under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2
-- of the License, or (at your option) any later version.
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
-- GNU General Public License for more details.
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
-- USA.
-- Toyoaki Sagawa,
-- PXW07530@nifty.ne.jp
-- http://www.morphyplanning.co.jp/FreeCPU/freecpu-e.html
-- Postal 113-0034 Yusima, 4-11-16-808 Bunkyo, Tokyo, Japan

-- 
-- Sayuri Interrupt State Machine
-- 2000/08/30 Rev.1.0 Toyozou
-- 
library IEEE;
use IEEE.std_logic_1164.all;

entity INTSTATE is
    port (
        INTERRUPT: in STD_LOGIC;		-- if 1, interrupt occured
        CLK: in STD_LOGIC;
        RESET: in STD_LOGIC;
        CORESTOP: out STD_LOGIC;		-- if 1, core & IP counter must stop
	MODEON: out STD_LOGIC;			-- if 1, mode register will change
        EPRWE: out STD_LOGIC;			-- WE for EPR register
        IPWE: out STD_LOGIC;			-- WE for IP
        IPOE: out STD_LOGIC;			-- OE for IP
        EJROE: out STD_LOGIC			-- OE for EJR
    );
end INTSTATE;

architecture INTSTATE_arch of INTSTATE is
 	type STATE is (IDLE, EPRA, EPRB, EJR, WAITINTCLR); -- needs 4 state for interrupt
 	signal CURRENT_STATE : STATE;
begin

  process (CLK, RESET) begin
  if (RESET = '0') then
	CURRENT_STATE <= IDLE;
   elsif (CLK'event and CLK='1') then
	if (INTERRUPT = '1' and CURRENT_STATE = IDLE)then
		CURRENT_STATE <= EPRA;
	elsif (CURRENT_STATE = EPRA)then
		CURRENT_STATE <= EPRB;
	elsif (CURRENT_STATE = EPRB)then
		CURRENT_STATE <= EJR;
	elsif (CURRENT_STATE = EJR)then
		CURRENT_STATE <= WAITINTCLR;
	elsif (INTERRUPT = '1' and CURRENT_STATE = WAITINTCLR)then
		CURRENT_STATE <= WAITINTCLR;
	else
		CURRENT_STATE <= IDLE;
	end if;
   end if;
  end process;

  process (CURRENT_STATE) begin
	case CURRENT_STATE is
	when IDLE => 
		CORESTOP 	<= '0';
		MODEON		<= '0';
		EPRWE 		<= '0';
		IPWE 		<= '0';
		IPOE 		<= '0';
		EJROE 		<= '0';
	when EPRA =>  -- in this state, "mode" is still 0.
		CORESTOP 	<= '1';
		MODEON		<= '1';
		EPRWE 		<= '0';
		IPWE 		<= '0';
		IPOE 		<= '0';
		EJROE 		<= '0';
	when EPRB =>  -- in this state, "mode" is 1, so EPR is written at this state.
		CORESTOP 	<= '1';
		MODEON		<= '0';
		EPRWE 		<= '1';
		IPWE 		<= '0';
		IPOE 		<= '1';
		EJROE 		<= '0';
	when EJR =>  
		CORESTOP 	<= '1';
		MODEON		<= '0';
		EPRWE 		<= '0';
		IPWE 		<= '1';
		IPOE 		<= '0';
		EJROE 		<= '1';
	when others =>
		CORESTOP 	<= '0';
		MODEON		<= '0';
		EPRWE 		<= '0';
		IPWE 		<= '0';
		IPOE 		<= '0';
		EJROE 		<= '0';
	end case;	
  end process;
  
end INTSTATE_arch;







