-- Sayuri GNU Public Licence 32 bit CPU design/implementation
-- Sayuri 32 bit RISC
-- Copyright (C) 2000 Toyoaki Sagawa.
-- This program/design/implementation is a free software/hardware design 
-- (and all intellectual property therein); you can redistribute it and/or
-- modify it under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2
-- of the License, or (at your option) any later version.
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
-- GNU General Public License for more details.
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
-- USA.
-- Toyoaki Sagawa,
-- PXW07530@nifty.ne.jp
-- http://www.morphyplanning.co.jp/FreeCPU/freecpu-e.html
-- Postal 113-0034 Yusima, 4-11-16-808 Bunkyo, Tokyo, Japan


-- 
-- Sayuri Comparator module
-- 2000/08/20 Rev.1.1 Toyozou
-- 
-- 8/20 change 1 base reg & 1 output reg

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_arith.all;

entity CMP is
    port (
        DIN: in STD_LOGIC_VECTOR (31 downto 0);
        DOUT: out STD_LOGIC_VECTOR (31 downto 0);
        CLK: in STD_LOGIC;
        WE: in STD_LOGIC_VECTOR (7 downto 0);
        OE: in STD_LOGIC_VECTOR(1 downto 0)
    );
end CMP;

architecture CMP_arch of CMP is
	signal OUTREG: std_logic;
	signal REGA : std_logic_vector(31 downto 0);
begin

  process(OE, OUTREG) begin
	case OE is
	when "01" =>  -- BASE REG
		DOUT <= REGA;
	when "10" =>  -- OUTPUT REG
		if (OUTREG = '0') then
			DOUT <= (others => '0');
		else
			DOUT <= ( 0 => '1', others => '0');
		end if;
	when others => DOUT <= (others => '0');
	end case;
  end process;

  process (CLK) begin
   if (CLK'event and CLK='1') then
	case WE is
	when "00000001" =>   -- BASE REG
		REGA <= DIN;
		OUTREG <= OUTREG;
	when "00000010" =>   -- OUTPUT REG
		REGA <= REGA;
		OUTREG <= DIN(0);
	when "00000100" =>  -- EQ then 0
		if (REGA = DIN) then
			OUTREG <= '0';
		else
			OUTREG <= '1';
		end if;
		REGA <= REGA;
	when "00001000" =>  -- Not EQ then 0
		if (REGA /= DIN) then
			OUTREG <= '0';
		else
			OUTREG <= '1';
		end if;
		REGA <= REGA;
	when "00010000" =>  -- GT A > DIN then 0
		if (REGA > DIN) then
			OUTREG <= '0';
		else
			OUTREG <= '1';
		end if;
		REGA <= REGA;
	when "00100000" =>  -- GT Signed A > DIN then 0
		if (CONV_INTEGER(REGA) > CONV_INTEGER(DIN)) then
			OUTREG <= '0';
		else
			OUTREG <= '1';
		end if;
		REGA <= REGA;
	when "01000000" =>  -- GE A >or= DIN then 0
		if (REGA >= DIN) then
			OUTREG <= '0';
		else
			OUTREG <= '1';
		end if;
		REGA <= REGA;
	when "10000000" =>  -- GE Signed A >or= DIN then 0
		if (CONV_INTEGER(REGA) >= CONV_INTEGER(DIN)) then
			OUTREG <= '0';
		else
			OUTREG <= '1';
		end if;
		REGA <= REGA;
	when others => OUTREG <= OUTREG; REGA <= REGA;
	end case;
    end if;
  end process;
  
end CMP_arch;





