-- Sayuri GNU Public Licence 32 bit CPU design/implementation
-- Sayuri 32 bit RISC
-- Copyright (C) 2000 Toyoaki Sagawa.
-- This program/design/implementation is a free software/hardware design 
-- (and all intellectual property therein); you can redistribute it and/or
-- modify it under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2
-- of the License, or (at your option) any later version.
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
-- GNU General Public License for more details.
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
-- USA.
-- Toyoaki Sagawa,
-- PXW07530@nifty.ne.jp
-- http://www.morphyplanning.co.jp/FreeCPU/freecpu-e.html
-- 
-- Postal 113-0034 Yusima, 4-11-16-808 Bunkyo, Tokyo, Japan

-- 
-- Sayuri EPR & EJR module
-- Exception ProducedAddress Register,and Exception Jump register.
-- 2000/08/25 Rev.1.0 Toyozou
-- 
-- EPR: IP is kept in this REG. 
-- EJR: used for Jump Vector Address.
-- 

library IEEE;
use IEEE.std_logic_1164.all;

entity EPREJR is
    port (
	DIN: in STD_LOGIC_VECTOR (31 downto 0);  	-- Software Interrupt Vector
	DOUT: out STD_LOGIC_VECTOR (31 downto 0);
	CLK: in STD_LOGIC;
	MODE: in STD_LOGIC; 						-- kernel mode/user mode, 1/0
	WE: in STD_LOGIC_VECTOR(1 downto 0);
	OE: in STD_LOGIC_VECTOR(1 downto 0)
    );
end EPREJR;

architecture EPREJR_arch of EPREJR is
	signal EPRREG : std_logic_vector(31 downto 0);
	signal EJRREG : std_logic_vector(31 downto 0);
begin
  process(OE, EPRREG, EJRREG) begin
	case OE is
	when "01" =>
		DOUT <= EPRREG;
	when "10" =>
		DOUT <= EJRREG;
	when others =>
		DOUT <= (others => '0');
	end case;
  end process;

  process (CLK) begin
    if (CLK'event and CLK='1') then
		case WE is
		when "01" => -- EPR register
			if MODE = '1' then  -- must be in kernel mode to write EPR
				EPRREG <= DIN;
			else
				EPRREG <= EPRREG;
			end if;
			EJRREG <= EJRREG;
		when "10" =>  -- EJR register
			EPRREG <= EPRREG;
			if MODE = '1' then  -- must be in kernel mode to write EJR
				EJRREG <= DIN;
			else
				EJRREG <= EJRREG;
			end if;
		when others => 		
			EPRREG <= EPRREG;
			EJRREG <= EJRREG;
		end case;
   end if;
  end process;

end EPREJR_arch;


