-- Sayuri GNU Public Licence 32 bit CPU design/implementation
-- Sayuri 32 bit RISC
-- Copyright (C) 2000 Toyoaki Sagawa.
-- This program/design/implementation is a free software/hardware design 
-- (and all intellectual property therein); you can redistribute it and/or
-- modify it under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2
-- of the License, or (at your option) any later version.
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
-- GNU General Public License for more details.
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
-- USA.
-- Toyoaki Sagawa,
-- PXW07530@nifty.ne.jp
-- http://www.morphyplanning.co.jp/FreeCPU/freecpu-e.html
-- Postal 113-0034 Yusima, 4-11-16-808 Bunkyo, Tokyo, Japan

-- 
-- Sayuri CORE module
-- 2000/08/20 Rev.1.0 Toyozou
-- 
-- 8/20 output is '0' when not selected

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_arith.all;

entity CORE is
    port (
	STATIN: in STD_LOGIC;  -- input data from STATBIT
	INSTRUCTION: in STD_LOGIC_VECTOR(31 downto 0);  -- input data from Instruction Mem.
	CORESTOP: in STD_LOGIC;
	DOUT: out STD_LOGIC_VECTOR(31 downto 0); -- output for Imm16
	WE: out STD_LOGIC_VECTOR(255 downto 0);
	OE: out STD_LOGIC_VECTOR(255 downto 0)
    );
end CORE;

architecture CORE_arch of CORE is

  function DECODE( A: in STD_LOGIC_VECTOR; B: in STD_LOGIC)
		return STD_LOGIC_VECTOR;

  function DECODE ( A: in STD_LOGIC_VECTOR; B: in STD_LOGIC)
		return STD_LOGIC_VECTOR is
  variable TMP : std_logic_vector(2**(A'Length)-1 downto 0);
  variable A_INT : integer;

  begin
	TMP := (others =>'0');
	if (B = '0') then
		A_INT := CONV_INTEGER(A);
		TMP(A_INT) := '1';
	else
		TMP := (others =>'0');
	end if;
	return TMP;
  end DECODE;

begin

  process(INSTRUCTION, STATIN) begin
	case INSTRUCTION(31 downto 28) is
	when "1110" =>  -- MOV instruction
		DOUT <=(others => '0');
		WE <= DECODE(INSTRUCTION(23 downto 16), CORESTOP);
		OE <= DECODE(INSTRUCTION(15 downto 8), CORESTOP);
	when "1010" =>  -- TEST & MOV instruction
		if (STATIN = '0') then
		DOUT <=(others => '0');
		WE <= DECODE(INSTRUCTION(23 downto 16), CORESTOP);
		OE <= DECODE(INSTRUCTION(15 downto 8), CORESTOP);
		else
		DOUT <=(others => '0');
		WE <= (others => '0');
		OE <= (others => '0');
		end if;
	when "1101" =>  -- IMM16 instruction
		DOUT <= "0000000000000000" & INSTRUCTION(15 downto 0);
		WE <= DECODE(INSTRUCTION(23 downto 16), CORESTOP);
		OE <= (others =>'0');
	when others =>
		DOUT <=(others => '0');
		WE <= (others =>'0');
		OE <= (others =>'0');
	end case;
  end process;

end CORE_arch;







