//-----------------------------------------------------------------------------
//
// Author: John Clayton
// Date  : April 30, 2001
// Update: April 30, 2001 Copied this file from "lcd_3.v" for use as top level
// Update: May    3, 2001 Included instantiations of VHDL code, to test mixed
//                        language support of the XILINX foundation 3.1 tools.
// Update: June   1, 2001 Brigham Young's 200th birthday!
//                        Started project "build_4" using ps2 interface and
//                        the rs232 interface code.
// Update: June   5, 2001 Finished debugging the keyboard ps2 interface.
//                        Removed debug outputs from keyboard interface.
// Update: June   7, 2001 Added the new ps2_mouse_interface module. ("build_5")
// Update: July  19, 2001 Removed the ps2_keyboard interface.  Added
//                        rs232_syscon module.  Copied this file from
//                        "top.v" of build_5.
// Update: Aug.   6, 2001 Removed the ps2_mouse_interface.  Added reg_8_pack,
//                        and ancillary register definitions for testing.
//
// Description
//-----------------------------------------------------------------------------
// This targets an XC2S200 board which was created for educational purposes.
//
// There are:
//    8  LEDs (led[7:0])
//    4  switches (switch[3:0])
//    1  clock of 32.000 MHz clock, present on GCLK1
//    1  clock of 49.152 MHz clock, present on GCLK0
//    4  lines of ps2 clock input (port A in documentation notes)
//    4  lines of ps2 data input (port A in documentation notes)
//    16 lines of LCD panel control (port B in documentation notes)
//    2  lines of rs232 serial connection (port C in documentation notes)
//-----------------------------------------------------------------------------


`resetall
`timescale 1ns/100ps

module top (
  sys_clk_0,
  sys_clk_1,
  switch,
  led,
  ps2_clk,
  ps2_data,
  lcd_drive,
  rs232_rxd,
  rs232_txd,
  debug_o
  );


output [13:0] debug_o;

// I/O declarations
input sys_clk_0;      // 49.152 MHz
input sys_clk_1;      // 32.000 MHz
input [3:0] switch;
input rs232_rxd;

inout [3:0] ps2_clk;
inout [3:0] ps2_data;

output [7:0] led;

output [15:0] lcd_drive;
output rs232_txd;

// Internal signal declarations

reg [9:0] crosshair_x_pos;
reg [9:0] crosshair_y_pos;

wire [7:0] lcd_control;
wire [11:0] dac_1_word;   // input to dac

reg clk_s;               // 49.152/2 MHz = 24.576 MHz

wire [15:0] adr;
wire [15:0] dat;
wire we;
wire stb;
wire rst;
wire sel_1;
wire sel_2;
wire master_br;

wire reset = switch[0];  // Simply a renaming exercise

wire [7:0] led_data;
wire dac_1;

//--------------------------------------------------------------------------
// Clock generation
//--------------------------------------------------------------------------

// This uses up an additional GCLK resource.
always @(posedge sys_clk_0)
begin
  clk_s <= ~clk_s;
end

//--------------------------------------------------------------------------
// Instantiations
//--------------------------------------------------------------------------

lcd_test_pongball_crosshair lcd_block (
  .sys_clk(sys_clk_1),
  .lcd_clk(sys_clk_0),
  .sys_reset(lcd_control[1]),
  .lcd_reset(lcd_control[0]),
  .ball_x_enable(lcd_control[2]),
  .ball_y_enable(lcd_control[3]),
  .crosshair_x_pos(crosshair_x_pos),
  .crosshair_y_pos(crosshair_y_pos),
  .crosshair_color(lcd_control[6:4]),
  .lcd_drive(lcd_drive)
  );

rs232_syscon #(
               4,             // Number of Hex digits for addresses.
               4,             // Number of Hex digits for data.
               2,             // Number of Hex digits for quantity.
               16,            // Characters in the input buffer
               4,             // Bits in the buffer pointer
               255,           // Clocks before watchdog timer expires
               8,             // Bits in watchdog timer
               8,             // Number of data fields displayed per line
               3,             // Number of bits in the fields counter
               2              // Number of bits in the digits counter
               )
  syscon_1 (                  // instance name
  .clk_i(clk_s),
  .reset_i(reset),
  .master_bg_i(master_br),
  .ack_i(switch[1]),
  .err_i(switch[2]),
  .master_adr_i(16'b0),
  .rs232_rxd_i(rs232_rxd),
  .dat_io(dat),
  .rst_o(rst),
  .master_br_o(master_br),
  .stb_o(stb),
  .cyc_o(),
  .adr_o(adr),
  .we_o(we),
  .rs232_txd_o(rs232_txd)
  );


assign sel_1 = ((adr[15:3] == 0) && stb);

reg_8_pack #(
             8,               // Size of r0
             8,               // Size of r1
             10,              // Size of r2
             10,              // Size of r3
             8,               // Size of r4
             16,              // Size of r5
             16,              // Size of r6
             16,              // Size of r7
             1,               // Read only regs.
             16               // Size of the data bus.
             )
  reg_8_pack_1                // Instance name
  (
   .clk_i(clk_s),
   .rst_i(rst),
   .sel_i(sel_1),
   .we_i(we),
   .adr_i(adr[2:0]),
   .dat_io(dat),
   .r0({~ps2_clk,~ps2_data}),
   .r1(led_data),
   .r2(crosshair_x_pos),
   .r3(crosshair_y_pos),
   .r4(lcd_control),
   .r5(),
   .r6(),
   .r7()
   );

assign sel_2 = ((adr[15:3] == 1) && ~adr[2] && stb);

reg_4_pack #(
             8,               // Size of r0
             12,              // Size of r1
             10,              // Size of r2
             10,              // Size of r3
             1,               // Read only regs.
             16               // Size of the data bus.
             )
  reg_4_pack_1                // Instance name
  (
   .clk_i(clk_s),
   .rst_i(rst),
   .sel_i(sel_2),
   .we_i(we),
   .adr_i(adr[1:0]),
   .dat_io(dat),
   .r0(lcd_control),
   .r1(dac_1_word),
   .r2(),
   .r3()
   );


dac_sigma_delta #(12)  // Size in bits
  dac_1                // Instance name
       (
        .clk_i(sys_clk_0),
        .rst_i(rst),
        .dat_i(dac_1_word),
        .dac_o(dac_1)
        );

assign led[7:4] = led_data[7:4] & {4{dac_1}};
assign led[3:0] = led_data[3:0] & {4{~dac_1}};
assign debug_o[12] = dac_1;

//--------------------------------------------------------------------------
// Module code
//--------------------------------------------------------------------------

assign debug_o[13] = switch[3];
assign debug_o[11:0] = {12{switch[3]}};

endmodule

