library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use work.risc_core_lib.all;

entity state_ctrl is
	port(	clock 			: in std_logic;
			ar_clk 			: out std_logic;
			alu_clk 			: out std_logic;
			regarray_clk 	: out std_logic;
			pc_clk 			: out std_logic;
			pc_reset			: out std_logic;
			opc_clk			: out std_logic;
			instruction		: in std_logic_vector(5 downto 0);
			reset				: in std_logic;
			regout_clk		: out std_logic;
			sp_reset			: out std_logic;
			sp_clk			: out std_logic;
			flag_clk			: out std_logic);
end state_ctrl;

architecture behavioral of state_ctrl is

signal current_state 	: state;
alias inst : std_logic_vector(1 downto 0) is instruction(5 downto 4);
begin
	phase_proc : process(clock, reset)
	variable load_state : state;
	begin
		if (reset = '1') then
			current_state <= reset_state1;
		elsif (clock'event and clock = '1') then
			opc_clk <= '0';
			ar_clk <= '0';
			alu_clk <= '0';
			regarray_clk <= '0';
			pc_clk <= '0';
			regout_clk <= '0';
			sp_clk <= '0';
			flag_clk <= '0';
		case current_state is
			when reset_state1 =>
				pc_reset <= '1';
				sp_reset <= '1';
				current_state <= reset_state2;
								  
			when reset_state2 =>
				ar_clk <= '1';
				current_state <= reset_state3;

			when reset_state3 =>
				pc_reset <= '0';
				sp_reset <= '0';
				current_state <= Fetch;

			when Fetch =>		--Phase 1
				opc_clk <= '1';
				current_state <= Load;
				
			when Load =>		--Phase 2
				load_state := get_next_state(inst);
					if (load_state = Trans_load) then
							if instruction = mov_indirekt_rd or
								instruction = mov_indiziert_rd then
									ar_clk <= '1';
							end if;
							if instruction = pop then
								sp_clk <= '1';
							end if;
							pc_clk <= '1';
							regout_clk <= '1';
							current_state <= Trans_exe;
					elsif (load_state = Arith_load) then
							current_state <= Arith_exe;
							pc_clk <= '1';
							regout_clk <= '1';
					elsif (load_state = Control_load) then
							if instruction = call then
								ar_clk <= '1';
							elsif instruction = ret  then
								sp_clk <= '1';
							end if;
							current_state <= Control_exe;
					else
							current_state <= reset_state1;
					end if;

			when Trans_exe =>		--Phase 3
				if instruction = pop or
					instruction = push then
						ar_clk <= '1';
				end if;
				alu_clk <= '1';
				current_state <= Trans_wb;

			when Trans_wb =>		--Phase 4
				if instruction = mov_direkt or
					instruction = movi or
					instruction = movih or
					instruction = mov_indirekt_rd or
					instruction = mov_indiziert_rd or
				 	instruction = pop then
						regarray_clk <= '1';
				elsif instruction = push then
						sp_clk <= '1';
				else
						ar_clk <= '1';
				end if;
				current_state <= Fetch;

			when Arith_exe =>		--Phase 3
				alu_clk <= '1';
				current_state <= Arith_wb;

			when Arith_wb =>		--Phase 4
				if (instruction /= cmp and
					instruction /= cmpi) then
						regarray_clk <= '1';
				end if;
				flag_clk <= '1';
				current_state <= Fetch;

			when Control_exe =>	--Phase 3
				if instruction = call then
					sp_clk <= '1';
				end if;
				if instruction = ret then
					ar_clk <= '1';
				end if;
				alu_clk <= '1';
				current_state <= Control_wb;

			when Control_wb =>	--Phase 4
				pc_clk <= '1';
				current_state <= Fetch;

			when others =>
				current_state <= reset_state1;
		end case;
		end if;
	end process;
end behavioral;
