library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity stackpointer is
    Port ( ctrl 		: in std_logic;
           reset 		: in std_logic;
           clock 		: in std_logic;
           adresse 	: out std_logic_vector(7 downto 0));
end stackpointer;

architecture behavioral of stackpointer is

signal	tmp : std_logic_vector(7 downto 0);
begin
	process(clock, reset)
		begin
			if (reset = '1') then							--reset SP to 0
				tmp <= "00000011";
			elsif (clock'event and clock = '1') then
				if (ctrl = '1') then  						--decrement SP
					tmp <= tmp - 1;
				else												--increment SP
					tmp <= tmp + 1;			
				end if;
			end if;
	end process;
	adresse <= tmp;
end behavioral;
