library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity pcmux is
    Port ( data_a 	: in std_logic_vector(15 downto 0);
           data_b 	: in std_logic_vector(15 downto 0);
			  data_c		: in std_logic_vector(9 downto 0);
           ctrl 		: in std_logic_vector(1 downto 0);	-- 00 = data_a (aluout)
			  																-- 01 = data_b (dm_rd)
													-- 10 = signed(data_a(aluout)+ data_c(codeadr))
           pc_adr 	: out std_logic_vector(9 downto 0));
end pcmux;

architecture behavioral of pcmux is

begin

	pc_adr <=	data_b(9 downto 0)		when ctrl = "01" else
					data_a(9 downto 0) + ("00"&data_c(7 downto 0)) when ((ctrl ="10") and
																						 (data_a(7) = '0')) else
					data_a(9 downto 0) + ("11"&data_c(7 downto 0)) when ((ctrl ="10") and
																						 (data_a(7) = '1')) else
					data_a(9 downto 0);
end behavioral;
