library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use work.risc_core_lib.all;

entity decoder is
	port(	opc 				: in std_logic_vector(15 downto 0);
			algorithmus		: out std_logic_vector(3 downto 0);
			alu_input_sel	: out std_logic_vector(1 downto 0);
			regarray_ctrl	: out std_logic_vector(5 downto 0);	--instruction selection (4) and bmux (2)
			dm_ctrl			: out std_logic;						--1=wr, 0=rd
			aalu_ctrl 		: out std_logic_vector(1 downto 0);		--R0, opd or add both
			pc_ctrl			: out std_logic; -- 0=increment 1=load
			regarray_in_ctrl : out std_logic_vector(3 downto 0); --Bit3: 0=alu, 1=dm
			sp_ctrl			: out std_logic;
			amux_ctrl		: out std_logic;
			pcmux_ctrl		: out std_logic_vector(1 downto 0);
			datamux_ctrl	: out std_logic_vector(1 downto 0);
			flagstatus		: in std_logic_vector(3 downto 0));
end decoder;

architecture behavioral of decoder is

alias	instruction	: std_logic_vector(5 downto 0) is opc(15 downto 10);
alias operand_1	: std_logic_vector(2 downto 0) is opc(8 downto 6);
alias operand_2	: std_logic_vector(2 downto 0) is opc(5 downto 3);
alias operand_3	: std_logic_vector(2 downto 0) is opc(2 downto 0);
alias reg_out_a	: std_logic_vector(2 downto 0) is regarray_ctrl(2 downto 0);
alias reg_out_b	: std_logic_vector(2 downto 0) is regarray_ctrl(5 downto 3);
alias cf				: std_logic is flagstatus(0); --carryflag
alias zf				: std_logic is flagstatus(1); --zeroflag
alias nf				: std_logic is flagstatus(2); --negativ flag
alias ovf			: std_logic is flagstatus(3); --overflowflag
signal branch 		: std_logic;

begin

	branch <= '1'	when	(((instruction = jcs) and (cf = '1')) or
								((instruction = jcc) and (cf = '0')) or
								((instruction = jeq) and (zf = '1')) or
							  	((instruction = jne) and (zf = '0')) or
							 	((instruction = jns) and (nf = '1')) or
								((instruction = jnc) and (nf = '0')) or
								((instruction = jos) and (ovf = '1')) or
								((instruction = joc) and (ovf = '0'))) else
				 '0';

	with instruction select
		algorithmus <= alu_pass_a when mov_indirekt_wr | mov_indiziert_wr,
							alu_pass_b when mov_direkt | movi | mov_indiziert_rd | jmp | call |
													jcs | jcc | jeq | jne | jns | jnc | jos | joc,
							alu_add when add | addi,
							alu_sub when lsub | subi,
							alu_and when land | andi,
							alu_or when lor | ori,
							alu_eor when eor | eori,
							alu_dec when dec,
							alu_inc when inc,
							alu_movih when movih,
							alu_sl when sl,
							alu_sr when sr,
							alu_rl when rl,
							alu_rr when rr,
							alu_cmp when cmp | cmpi,
							alu_mul when mul,
							alu_pass_a when others;

	with instruction select
		reg_out_a <=	operand_1 when dec | inc | sl | sr | rl | rr | cmp,
							operand_2 when mov_indirekt_wr | add | lsub | land | lor | eor | mul,
							("0" & opc(9 downto 8)) when mov_indiziert_wr | addi | subi |
																	andi | ori | eori | movih | cmpi,
							operand_1 when others;

	with instruction select
		reg_out_b <=	operand_1 when mov_indirekt_wr | push,											
							operand_2 when mov_direkt | mov_indirekt_rd | cmp,
							operand_3 when add | lsub| land | lor | eor | mul,
							R0 when mov_indiziert_rd | mov_indiziert_wr,
							operand_1 when others;

	with instruction select
		alu_input_sel <=
							b_input_reg when mov_direkt | mov_indirekt_wr | mov_indiziert_wr |
													add | lsub | land | lor | eor | cmp | mul,
							b_input_opd when movi | mov_indiziert_rd | addi | subi | andi |
													ori | eori | jmp | movih | call | cmpi |
													jcs | jcc | jeq | jne | jns | jnc | jos | joc,
							b_input_reg when others;

	with instruction select
		dm_ctrl <=		'1' when mov_indirekt_wr | mov_indiziert_wr | call | push,		--1=write
							'0' when others; --0=read

	with instruction select
		aalu_ctrl <=	"10" when mov_indiziert_rd | mov_indiziert_wr,	--10=add
							"00" when others;--00=reg

--	with instruction select
--		pc_ctrl <= 		'1' when jmp | call | ret,	--load
--							'0' when others; --increment

		pc_ctrl <= 		'1' when ((instruction = jmp) or
										(instruction = call) or
										(instruction = ret) or
										(branch = '1')) else
							'0';

	with instruction select
		regarray_in_ctrl <=
							("0" & operand_1)	when mov_direkt | add | 		--von ALU auf Op1
															lsub | land | lor | eor | dec | inc |
															sl | sr | rl | rr | mul,
							("1" & operand_1) when mov_indirekt_rd | pop, 			--von dm auf Op1
							("00" & opc(9 downto 8)) when movi | movih,		--von ALU auf R0..R3
							("10" & opc(9 downto 8)) when	mov_indiziert_rd,	--von dm auf R0..R3
							"0000" when others;										--von ALU auf Register0

	with instruction select
		sp_ctrl <= 		'1' when ret | pop,	--decrement
							'0' when others; 		--increment

	with instruction select
		amux_ctrl <= 	'1' when call | ret | push | pop,	--stackpointer adr
							'0' when others; 		--aalu adr

	with instruction select
		pcmux_ctrl <= 	"01" when 	ret,			--direkt von dm
							"10" when 	jcs | jcc | jeq | jne |
											jos | joc | jns | jnc,	--add signed aluout + codeadr
							"00" when others; 	--von alu

	with instruction select
		datamux_ctrl <=	"01" when call,	--codeadresse + 1
								"10" when push,	--regalub
								"00" when others; --alu out

end behavioral;
