library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use work.risc_core_lib.all;

entity Reg_array is
	port(	in_a 				: in 	std_logic_vector(15 downto 0);
			in_sel 			: in 	std_logic_vector(3 downto 0);
			regarray_clk 	: in 	std_logic;
			out_a 			: out std_logic_vector(15 downto 0);
			out_b 			: out std_logic_vector(15 downto 0);
			out_sel 			: in 	std_logic_vector(5 downto 0);
			in_b 				: in 	std_logic_vector(15 downto 0);
			regout_clk		: in std_logic);
end Reg_array;

architecture behavioral of Reg_array is

alias in_sel_in : std_logic is in_sel(3);		-- 0=in_a(alu), 1=in_b(dm)
alias in_sel_reg : std_logic_vector(2 downto 0) is in_sel (2 downto 0);
alias	out_a_sel : std_logic_vector(2 downto 0) is out_sel (2 downto 0);
alias	out_b_sel : std_logic_vector(2 downto 0) is out_sel (5 downto 3);
--shared variable Regdata : Registerarray_8;
signal Regdata : Registerarray_8;
begin
	process(regarray_clk)
	begin
		if (regarray_clk'event and regarray_clk = '1') then
			--Register beschreiben
			case in_sel_in is
				when '0' =>			--input_a aktiv
					Regdata(conv_integer(in_sel_reg)) <= in_a;
				when '1' =>			--input_b aktiv
					Regdata(conv_integer(in_sel_reg)) <= in_b;
				when others =>							
			end case;
		end if;
	end process;

	process(regout_clk)
	begin
	if (regout_clk'event and regout_clk = '1') then
		--Registerinhalt ausgeben
		out_a <= Regdata(conv_integer(out_a_sel));
		out_b <= Regdata(conv_integer(out_b_sel));
	end if;
	end process;
end behavioral;
