--	Package for RISC_Core
-- 14.9.01 M.Imhof


library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.all;

package RISC_Core_lib is

-- Typendefinitionen
	type state is (Fetch, Load, Trans_load, Trans_exe, Trans_wb,
						Arith_load, Arith_exe, Arith_wb,
						Control_load, Control_exe, Control_wb,
						reset_state1, reset_state2, reset_state3);	 
	type Registerarray_8 is array(0 to 7) of std_logic_vector(15 downto 0);

-- Funktionsdeklarationen
	function get_next_state(opcode : in std_logic_vector(1 downto 0))
		return state;
	
-- Konstanten fuer ALU operation selection
	constant alu_pass_a 		: std_logic_vector(3 downto 0) := "0000";
	constant alu_pass_b 		: std_logic_vector(3 downto 0) := "0001";
	constant alu_add 			: std_logic_vector(3 downto 0) := "0010";
	constant alu_sub	 		: std_logic_vector(3 downto 0) := "0011";
	constant alu_cmp	 		: std_logic_vector(3 downto 0) := "0100";
	constant alu_and	 		: std_logic_vector(3 downto 0) := "0101";
	constant alu_or	 		: std_logic_vector(3 downto 0) := "0110";
	constant alu_eor	 		: std_logic_vector(3 downto 0) := "0111";
	constant alu_inc	 		: std_logic_vector(3 downto 0) := "1000";
	constant alu_dec	 		: std_logic_vector(3 downto 0) := "1001";
	constant alu_sl	 		: std_logic_vector(3 downto 0) := "1010";
	constant alu_sr	 		: std_logic_vector(3 downto 0) := "1011";
	constant alu_rl	 		: std_logic_vector(3 downto 0) := "1100";
	constant alu_rr	 		: std_logic_vector(3 downto 0) := "1101";
	constant alu_movih 		: std_logic_vector(3 downto 0) := "1110";
	constant alu_mul			: std_logic_vector(3 downto 0) := "1111";

--Konstanten fuer ALU input selection
	constant b_input_reg		: std_logic_vector(1 downto 0) := "00";
	constant b_input_opd		: std_logic_vector(1 downto 0) := "01";
	constant b_input_dm		: std_logic_vector(1 downto 0) := "10";

	constant R0					: std_logic_vector(2 downto 0) := "000";

--Konstanten fuer Instruktionen
	constant mov_direkt 		: std_logic_vector(5 downto 0) := "000000";
	constant movi 				: std_logic_vector(5 downto 0) := "000100";
	constant movih 			: std_logic_vector(5 downto 0) := "000101";
	constant mov_indirekt_rd	: std_logic_vector(5 downto 0) := "000001";
	constant mov_indiziert_rd	: std_logic_vector(5 downto 0) := "000110";
	constant mov_indirekt_wr	: std_logic_vector(5 downto 0) := "000010";
	constant mov_indiziert_wr	: std_logic_vector(5 downto 0) := "000111";

	constant add		 		: std_logic_vector(5 downto 0) := "010000";
	constant addi		 		: std_logic_vector(5 downto 0) := "010001";
	constant lsub		 		: std_logic_vector(5 downto 0) := "010010";
	constant subi		 		: std_logic_vector(5 downto 0) := "010011";
	constant cmp		 		: std_logic_vector(5 downto 0) := "010100";
	constant cmpi		 		: std_logic_vector(5 downto 0) := "010101";
	constant dec		 		: std_logic_vector(5 downto 0) := "010110";
	constant inc		 		: std_logic_vector(5 downto 0) := "010111";
	constant land		 		: std_logic_vector(5 downto 0) := "011000";
	constant andi		 		: std_logic_vector(5 downto 0) := "011001";
	constant eor		 		: std_logic_vector(5 downto 0) := "011010";
	constant eori		 		: std_logic_vector(5 downto 0) := "011011";
	constant lor		 		: std_logic_vector(5 downto 0) := "011100";
	constant ori		 		: std_logic_vector(5 downto 0) := "011101";
	constant sl			 		: std_logic_vector(5 downto 0) := "100000";
	constant sr			 		: std_logic_vector(5 downto 0) := "100001";
	constant rl			 		: std_logic_vector(5 downto 0) := "100010";
	constant rr			 		: std_logic_vector(5 downto 0) := "100011";
	constant mul		 		: std_logic_vector(5 downto 0) := "100100";

	constant nop		 		: std_logic_vector(5 downto 0) := "111000";
	constant jmp		 		: std_logic_vector(5 downto 0) := "111111";
	constant push		 		: std_logic_vector(5 downto 0) := "001000";
	constant pop		 		: std_logic_vector(5 downto 0) := "001001";
	constant call		 		: std_logic_vector(5 downto 0) := "111100";
	constant ret		 		: std_logic_vector(5 downto 0) := "111101";
	constant reti		 		: std_logic_vector(5 downto 0) := "111110";
	constant jcs		 		: std_logic_vector(5 downto 0) := "110101";
	constant jcc		 		: std_logic_vector(5 downto 0) := "110100";
	constant jeq		 		: std_logic_vector(5 downto 0) := "110111";
	constant jne		 		: std_logic_vector(5 downto 0) := "110110";
	constant jos		 		: std_logic_vector(5 downto 0) := "110001";
	constant joc		 		: std_logic_vector(5 downto 0) := "110000";
	constant jns		 		: std_logic_vector(5 downto 0) := "110011";
	constant jnc		 		: std_logic_vector(5 downto 0) := "110010";

end RISC_Core_lib;


package body RISC_Core_lib is

	--ermittelt die erste phase des naechsten Befehls
	function get_next_state(opcode : in std_logic_vector(1 downto 0))
		return state is
		variable new_state : state;
	begin
		if opcode = "00" then
--			opcode = mov_direkt or 
--			opcode = movi or
--			opcode = movih or
--			opcode = mov_indirekt_rd or 
--			opcode = mov_indiziert_rd or
--			opcode = mov_indirekt_wr or 
--			opcode = mov_indiziert_wr) or
--			opcode = push or
--		   opcode = pop then
 				new_state := Trans_load;
		elsif (opcode = "01" or
				 opcode = "10") then
--			(opcode = add or 
--			opcode = addi or
--			opcode = lsub or
--			opcode = subi or
--			opcode = cmp or
--			opcode = cmpi or
--			opcode = dec or
--			opcode = inc or
--			opcode = land or
--			opcode = andi or
--			opcode = eor or
--			opcode = eori or
--			opcode = lor or
--			opcode = ori or
--			opcode = sl or 
--			opcode = sr or 
--			opcode = rl or 
--			opcode = rr) then
 				new_state := Arith_load;
		elsif opcode = "11" then
--			(opcode = nop or
--	 		opcode = jmp or
--			opcode = call or
--			opcode = ret or
--			opcode = reti or
--			opcode = jcs or
--			opcode = jcc or
--			opcode = jeq or
--			opcode = jne or
--			opcode = jos or
--			opcode = joc or
--			opcode = jns or
--			opcode = jnc) then
			new_state := Control_load;
		else
			new_state := reset_state1;
		end if;
		return new_state;
	end get_next_state;

end RISC_Core_lib; 
