library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use work.risc_core_lib.all;

entity PC is
	port(	code_adr 	: out std_logic_vector(9 downto 0);
			pc_clk 		: in std_logic;		
			reset			: in std_logic;
			operand		: in std_logic_vector(9 downto 0);
			ctrl			: in std_logic);	-- 0=increase 1=load
end PC;

architecture behavioral of PC is
signal	tmp : std_logic_vector(9 downto 0);
begin
	process(pc_clk, reset)
		begin
			if (reset = '1') then							--reset PC to 0
				tmp <= "0000000000";
			elsif (pc_clk'event and pc_clk = '1') then
				if (ctrl = '1') then  						--load PC
					tmp <= operand;
				else												--increment PC			
					tmp <= tmp + 1;			
				end if;
			end if;
	end process;
	code_adr <= tmp;
end behavioral;
