--RTL of RISC_Core S
--14.9.01 M.Imhof
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
--use work.risc_core_lib.all;

entity CPU is
    Port ( clock	 		: in std_logic;
           opc_clk 		: out std_logic;
           ar_clk 		: out std_logic;
           dm_ctrl 		: out std_logic;
           opcode			: in std_logic_vector(15 downto 0);
           dm_rd 			: in std_logic_vector(15 downto 0);
           dm_wr 			: out std_logic_vector(15 downto 0);
           code_adr 		: out std_logic_vector(9 downto 0);
           data_adr 		: out std_logic_vector(15 downto 0);
			  reset			: in std_logic);					--Reset high aktiv
end CPU;

architecture rtl of CPU is
	
	component decoder
		port(	opc				: in std_logic_vector(15 downto 0);
				algorithmus		: out std_logic_vector(3 downto 0);
				alu_input_sel	: out std_logic_vector(1 downto 0);
				regarray_ctrl	: out std_logic_vector(5 downto 0);--instruction selection(4) and bmux(2)
				dm_ctrl			: out std_logic;							--1=wr, 0=rd
				aalu_ctrl 		: out std_logic_vector(1 downto 0);	--R0, opd or add both
				pc_ctrl			: out std_logic;
				regarray_in_ctrl : out std_logic_vector(3 downto 0);
				sp_ctrl			: out std_logic;
				amux_ctrl		: out std_logic;
				pcmux_ctrl		: out std_logic_vector(1 downto 0);
				datamux_ctrl	: out std_logic_vector(1 downto 0);
				flagstatus		: in std_logic_vector(3 downto 0));
	end component;

	component state_ctrl
		port(	clock 			: in std_logic;
				ar_clk 			: out std_logic;
				alu_clk 			: out std_logic;
				regarray_clk 	: out std_logic;
				pc_clk 			: out std_logic;
				pc_reset			: out std_logic;
				opc_clk			: out std_logic;
				instruction		: in std_logic_vector(5 downto 0);
				reset				: in std_logic;
				regout_clk		: out std_logic;
				sp_reset			: out std_logic;
				sp_clk			: out std_logic;
				flag_clk			: out std_logic);
	end component;

	component Reg_array
		port(	in_a 				: in std_logic_vector(15 downto 0);
				in_sel 			: in std_logic_vector(3 downto 0);
				regarray_clk 	: in std_logic;
				out_a 			: out std_logic_vector(15 downto 0);
				out_b 			: out std_logic_vector(15 downto 0);
				out_sel 			: in std_logic_vector(5 downto 0);
				in_b 				: in std_logic_vector(15 downto 0);
				regout_clk		: in std_logic);
	end component;
	
	component ALU
		port(	regarray_alu_a : in  std_logic_vector(15 downto 0);
				regarray_alu_b : in  std_logic_vector(15 downto 0);
				dm_rd 			: in  std_logic_vector(15 downto 0);
				data_out 		: out std_logic_vector(15 downto 0);
				opd 				: in  std_logic_vector(9 downto 0);
				algorithmus		: in 	std_logic_vector(3 downto 0);
				alu_input_sel	: in 	std_logic_vector(1 downto 0);
				alu_clk 			: in  std_logic;
				statusflag		: out std_logic_vector(3 downto 0));
	end component;

	component PC
		port(	code_adr 		: out std_logic_vector(9 downto 0);
				pc_clk 			: in std_logic;
				reset				: in std_logic;	--high aktiv
				operand			: in std_logic_vector(9 downto 0);
				ctrl				: in std_logic); 	-- 0=increase 1=load
	end component;

	component AALU
		port(	data_adr 		: out std_logic_vector(15 downto 0);
				regarray_alu_b : in std_logic_vector(15 downto 0);
				opd 				: in std_logic_vector(9 downto 0);
				aalu_ctrl 		: in std_logic_vector(1 downto 0));
	end component;

	component stackpointer is
    	port ( ctrl 			: in std_logic;	-- 0 = up, 1 = down
           	reset 			: in std_logic;	-- high aktiv
           	clock 			: in std_logic;
           	adresse 			: out std_logic_vector(7 downto 0));
	end component;
	
	component amux is
    	Port ( ctrl 	: in std_logic;
           aalu_adr 	: in std_logic_vector(15 downto 0);
           sp_adr 	: in std_logic_vector(7 downto 0);
           data_adr 	: out std_logic_vector(15 downto 0));
	end component;

	component pcmux is
    	Port ( data_a 	: in std_logic_vector(15 downto 0);
           data_b 	: in std_logic_vector(15 downto 0);
			  data_c		: in std_logic_vector(9 downto 0);
           ctrl 		: in std_logic_vector(1 downto 0);
           pc_adr 	: out std_logic_vector(9 downto 0));
	end component;

	component datamux is
    	Port ( data_a 	: in std_logic_vector(15 downto 0);
           data_b 	: in std_logic_vector(9 downto 0);
			  data_c		: in std_logic_vector(15 downto 0);
           ctrl 		: in std_logic_vector(1 downto 0);	-- 00 = aluout(default=
			  																--	01 = codeadr + 1
																			-- 10 = regalub
           data_out 	: out std_logic_vector(15 downto 0));
	end component;

	component flagreg is
    	Port ( setflag 	: in std_logic_vector(3 downto 0);
           	flagstat 	: out std_logic_vector(3 downto 0);
				clock			: in std_logic);
	end component;

signal	regalua, regalub, aluout,
			aaluadr						: std_logic_vector(15 downto 0);
signal	opreg, pcopd, codeadr	: std_logic_vector(9 downto 0);
signal	spadr							: std_logic_vector(7 downto 0);
signal	decregctrl, decscopc		: std_logic_vector(5 downto 0);
signal	reginctrl, algo, aluflag, flagdec : std_logic_vector(3 downto 0);
signal	aaluctrl, aluinsel,
			datamuxctrl, pcmuxctrl 	: std_logic_vector(1 downto 0);
signal	dmctrl, scregclk,
			scpcclk, aluclk, pc_res,
			pcctrl, regoutclk, spres,
			spclk, spctrl, amuxctrl, flagclk : std_logic;

begin
-- Port map "RTL RISC_Core S"
decoder1 	: decoder 	port map(opc => opcode,
											algorithmus => algo,
											alu_input_sel => aluinsel,
											regarray_ctrl => decregctrl,
											dm_ctrl => dm_ctrl,
											aalu_ctrl => aaluctrl, 
											pc_ctrl => pcctrl,
											regarray_in_ctrl => reginctrl,
											sp_ctrl => spctrl,
											amux_ctrl => amuxctrl,
											pcmux_ctrl => pcmuxctrl,
											datamux_ctrl => datamuxctrl,
											flagstatus => flagdec);
progcntr 	: PC 			port map(code_adr => codeadr,
											pc_clk => scpcclk,
											reset => pc_res,
											operand => pcopd,
											ctrl => pcctrl);
adralu 		: AALU 		port map(data_adr => aaluadr,
											regarray_alu_b => regalub,
										 	opd => opreg, 
											aalu_ctrl => aaluctrl);
alu1 			: ALU 		port map(regarray_alu_a => regalua,
											regarray_alu_b => regalub, 
											dm_rd => dm_rd, 
											data_out => aluout, 
											opd => opreg, 
											algorithmus => algo, 
											alu_input_sel => aluinsel,
											alu_clk => aluclk,
											statusflag => aluflag);
statectrl 	: state_ctrl port map(clock => clock, 
											ar_clk => ar_clk, 
											alu_clk => aluclk, 
											regarray_clk => scregclk, 
											pc_clk => scpcclk, 
											pc_reset => pc_res, 
											opc_clk => opc_clk,
											instruction => decscopc, 
											reset => reset,
											regout_clk => regoutclk,
											sp_reset => spres,
											sp_clk => spclk,
											flag_clk => flagclk);
regarray 	: Reg_array port map(in_a => aluout, 
											in_sel => reginctrl, 
											regarray_clk => scregclk, 
											out_a => regalua, 
											out_b => regalub,
											out_sel => decregctrl, 
											in_b => dm_rd,
											regout_clk => regoutclk);
sp				: stackpointer port map(
    										ctrl => spctrl,
           								reset => spres,
           								clock => spclk,
	           							adresse => spadr);
adressmux	: amux port map 		(ctrl => amuxctrl,
     										aalu_adr => aaluadr,
           								sp_adr => spadr,
           								data_adr => data_adr);
pcmux1 		:pcmux port map		(data_a => aluout,
		   					    		data_b => dm_rd,
											data_c => codeadr,
           								ctrl => pcmuxctrl,
           								pc_adr => pcopd);
datamux1		:datamux port map		(data_a => aluout,
           								data_b => codeadr,
											data_c => regalub,
           								ctrl => datamuxctrl,
           								data_out => dm_wr);
statusreg	: flagreg port map 	(setflag => aluflag,
											flagstat => flagdec,
											clock => flagclk);

opreg <= opcode(9 downto 0);		-- 10 Bit Konstante (#const10) der Instruktion
decscopc <= opcode(15 downto 10);
code_adr <= codeadr;
end rtl;


