library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use work.risc_core_lib.all;

entity ALU is
	port(	regarray_alu_a	: in std_logic_vector(15 downto 0);
			regarray_alu_b	: in std_logic_vector(15 downto 0);
			dm_rd				: in std_logic_vector(15 downto 0);
			data_out 		: out std_logic_vector(15 downto 0);
			opd				: in std_logic_vector(9 downto 0);
			algorithmus		: in 	std_logic_vector(3 downto 0);
			alu_input_sel	: in 	std_logic_vector(1 downto 0);
			alu_clk			: in std_logic;
			statusflag		: out std_logic_vector(3 downto 0));
end ALU;

architecture behavioral of ALU is

alias cf				: std_logic is statusflag(0); --carryflag
alias zf				: std_logic is statusflag(1); --zeroflag
alias nf				: std_logic is statusflag(2); --negativ flag
alias ovf			: std_logic is statusflag(3); --overflowflag
signal operand_b	: std_logic_vector(15 downto 0);

begin
	--Eingangsmultiplexer des b_inputs
	inputselector : process(alu_input_sel, regarray_alu_b, opd, dm_rd)
	begin
		case alu_input_sel is
			when b_input_reg =>
				operand_b <= regarray_alu_b;
			when b_input_opd =>
				operand_b <= ("00000000" & opd(7 downto 0));
			when b_input_dm =>
				operand_b <= dm_rd;
			when others =>
				operand_b <= "0000000000000000";
		end case;
 	end process;
	
	--Operationsausfuehrung
	ALUproc : process(alu_clk)	
	variable result : std_logic_vector(16 downto 0);
	begin
		if (alu_clk'event and alu_clk = '1') then
			case algorithmus is

				when alu_pass_a =>
					data_out <= regarray_alu_a;

				when alu_pass_b =>
					data_out <= operand_b;

				when alu_add =>
					--data_out <= (regarray_alu_a + operand_b);
					result := (('0' & regarray_alu_a) + ('0' & operand_b));
					ovf <= result(16);
					data_out <= result(15 downto 0);

				when alu_sub =>
					data_out <= (regarray_alu_a - operand_b);
					if operand_b > regarray_alu_a then
						nf <= '1';
					else
						nf <= '0';
					end if;

				when alu_cmp =>
					if (regarray_alu_a = operand_b) then
						zf <= '1';
					else
						zf <= '0';
					end if;
					if (operand_b > regarray_alu_a) then
						nf <= '1';
					else
						nf <= '0';
					end if;

				when alu_eor =>
					data_out <= (regarray_alu_a xor operand_b);

				when alu_and =>
					data_out <= (regarray_alu_a and operand_b);

				when alu_or =>
					data_out <= (regarray_alu_a or operand_b);

				when alu_mul =>
					data_out <= (regarray_alu_a * operand_b);

				when alu_inc =>
					data_out <= (regarray_alu_a + "0000000000000001");
					if regarray_alu_a = "1111111111111111" then
						ovf <= '1';
					else 
						ovf <= '0';
					end if;

				when alu_dec =>
					data_out <= (regarray_alu_a - "0000000000000001");
					if (regarray_alu_a = "0000000000000001") then
						zf <= '1';
					else 
						zf <= '0';
					end if;
					if (regarray_alu_a = "0000000000000000") then
						nf <= '1';
					else 
						nf <= '0';
					end if;

				when alu_sl =>
					data_out(0) <= '0';
					data_out(15 downto 1) <= regarray_alu_a(14 downto 0);
					cf <= regarray_alu_a(15);

				when alu_sr =>
					data_out(15) <= '0';
					data_out(14 downto 0) <= regarray_alu_a(15 downto 1);
					cf <= regarray_alu_a(0);

				when alu_rl =>
					data_out(0) <= regarray_alu_a(15);
					data_out(15 downto 1) <= regarray_alu_a(14 downto 0);

				when alu_rr =>
					data_out(15) <= regarray_alu_a(0);
					data_out(14 downto 0) <= regarray_alu_a(15 downto 1);

				when alu_movih =>
					data_out <= (operand_b(7 downto 0) & regarray_alu_a(7 downto 0));

				when others =>
					data_out <= "0000000000000000";
	  		end case;
		end if;
	end process;
end behavioral;
