library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use work.risc_core_lib.all;

entity AALU is
	port(	data_adr 		: out std_logic_vector(15 downto 0);
			regarray_alu_b : in std_logic_vector(15 downto 0);
			opd 				: in std_logic_vector(9 downto 0);
			aalu_ctrl 		: in std_logic_vector(1 downto 0));
end AALU;

architecture behavioral of AALU is
begin
	data_adr <=	regarray_alu_b								when	aalu_ctrl = "00" else
					"000000" & opd								when	aalu_ctrl = "01" else
					regarray_alu_b + ("000000" & opd)	when	aalu_ctrl = "10" else
					"0000000000000000";

end behavioral;
