;--
;-- Risc5x
;-- www.OpenCores.Org - November 2001
;--
;--
;-- This library is free software; you can distribute it and/or modify it
;-- under the terms of the GNU Lesser General Public License as published
;-- by the Free Software Foundation; either version 2.1 of the License, or
;-- (at your option) any later version.
;--
;-- This library is distributed in the hope that it will be useful, but
;-- WITHOUT ANY WARRANTY; without even the implied warranty of
;-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
;-- See the GNU Lesser General Public License for more details.
;--
;-- A RISC CPU core.
;--
;-- (c) Mike Johnson 2001. All Rights Reserved.
;-- mikej@opencores.org for support or any other issues.
;--
;-- Revision list
;--
;-- version 1.0 initial opencores release
;--
;
	LIST    p=16C58 ; PIC16C58 is the target processor


;
; Core Sanity Test
;
; JUMPTEST.ASM
;
; test some jumps
; test some inc & decs
; test some alu functions
; sit in loop multiplying port A with a constant
; output 16 bit result on ports C & B
;

CARRY   equ     H'00'   ; Carry bit in STATUS register
DC      equ     H'01'   ; DC    bit in STATUS register
ZERO    equ     H'02'   ; Zero  bit in STATUS register
W       equ     H'00'   ; W indicator for many instruction (not the address!)

INDF    equ     H'00'   ; Magic register that uses INDIRECT register
TIMER0  equ     H'01'   ; Timer register
PC      equ     H'02'   ; PC
STATUS  equ     H'03'   ; STATUS register F3
FSR     equ     H'04'   ; INDIRECT Pointer Register
porta   equ     H'05'   ; I/O register F5
portb   equ     H'06'   ; I/O register F6
portc   equ     H'07'   ; I/O register F7
x       equ     H'09'   ; scratch
y       equ     H'0A'   ; scratch
rh      equ     H'0B'   ; result h
rl      equ     H'0C'   ; result l

mult    MACRO   bit
	btfsc   y,bit
	addwf   rh,1
	rrf     rh,1
	rrf     rl,1
	ENDM

start:  movlw   H'ff'
	tris    porta   ; PORTA is Input
	clrw
	tris    portb   ; PORTB is Output
	tris    portc   ; PORTC is Output
	movwf   portb   ; PORTB <= 00

	movlw   h'0B'
	movwf   PC      ; move to pc (jump1)

	movlw   h'F0'   ; fail 0
	movwf   portb
	goto fail

jump1:  movlw   h'05'
	addwf   PC,f    ; jump forward to jump2
	movlw   h'F1'   ; fail 1
	movwf   portb
	goto fail

jump3:  goto    jump4   ; continue
	nop

jump2:  movlw   h'04'
	subwf   PC, f   ; jump back to jump 3

	movlw   h'F2'   ; fail 2
	movwf   portb
	goto fail

jump4:  movlw   h'04'   ; w <= 04
	movwf   x
	decf    x,f     ; x <= 03
	decf    x,f     ; x <= 02
	decf    x,f     ; x <= 01
	decf    x,f     ; x <= 00
	decf    x,f     ; x <= FF
	movf    x,w
	xorlw   h'FF'   ; does w = ff ?
	btfss   STATUS,ZERO ; skip if clear
	goto    fail
	incf    x,f     ; x <= 00
	incf    x,f     ; x <= 01
	movf    x,w
	xorlw   h'01'   ; does w = 01
	btfss   STATUS,ZERO
	goto    fail

	; test logic

	clrf    x       ; x <= 00
	movlw   h'a5'
	iorwf   x,f     ; x <= a5
	swapf   x,f     ; x <= 5a
	movlw   h'f0'
	andwf   x,f     ; x <= 50
	comf    x,f     ; x <= af
	movlw   h'5a'
	xorwf   x,f     ; x <= f5

	;check
	movfw   x
	xorlw   h'f5'
	btfsc   STATUS,ZERO
	goto test1
	movlw   h'F3'   ; fail 3
	movwf   portb
	goto fail

test1:  movlw   h'23'
	movwf   x       ; x <= 23
	movlw   h'e1'   ; w <= e1
	addwf   x,f     ; x <= 04
	btfss   STATUS,CARRY
	goto    fail    ; carry should be set
	movlw   h'02'   ; w <= 02
	subwf   x,f     ; x <= 02
	btfss   STATUS,CARRY
	goto    fail    ; borrow should be clear

	movlw   h'34'   ; w <= 34
	subwf   x,f     ; x <= ce
	btfsc   STATUS,CARRY
	goto    fail    ; borrow should be set

	movf    x,w
	xorlw   h'CE'
	btfss   STATUS,ZERO
	goto    fail    ; x /= ce

test2:  movlw   h'34'   ; test dc flag
	movwf   x
	movlw   h'0F'
	addwf   x,f     ; x <= 43
	btfsc   STATUS,CARRY
	goto    fail    ; carry should be clear
	btfss   STATUS,DC
	goto    fail    ; dc should be set
	movlw   h'01'
	subwf   x,f     ; x <= 42
	btfss   STATUS,CARRY
	goto    fail    ; borrow should be clear
	btfss   STATUS,DC
	goto    fail    ; dc borrow should be clear
	movlw   h'FF'
	subwf   x,f
	btfsc   STATUS,CARRY
	goto    fail    ; borrow should be set
	btfsc  STATUS,DC
	goto    fail    ; dc borrow should be set

	movf    x,w
	xorlw   h'43'   ; final check
	btfss   STATUS,ZERO
	goto    fail    ; x /= 43
	movlw   h'E0'   ; ok
	movwf   portb

loop1:                  ; mult x by y
	movf    porta,W
	movwf   x
	movlw   h'23'
	movwf   y

	clrf    rh
	clrf    rl
	movf    x,w
	bcf     STATUS,CARRY
	mult    0
	mult    1
	mult    2
	mult    3
	mult    4
	mult    5
	mult    6
	mult    7

	movf    rl,w
	movwf   portb   ; on port b low result
	movf    rh,w
	movwf   portc   ; on port c high result
	goto    loop1

fail:   goto    fail
	end
