// Test6
//
// This tests out the risc16f84 to see if it can perform calls to subroutines.
// It is supposed to print boxes of random colors and sizes to the LCD screen.
// Author: John Clayton
// Date  : 05/01/02

#device PIC16C84
#byte addr_lo = 0x05
#byte addr_hi = 0x06
#byte data = 0x08

// This functions plots a single pixel at coordinates (x,y)
// color should range from 0..7.
void plot(unsigned int x, unsigned int y, unsigned int color)
{
addr_hi = (y>>1) | 0x40;
addr_lo = x | (y<<7);
data = color;
}

void fill_block(unsigned int x1,
                unsigned int y1,
                unsigned int x2,
                unsigned int y2,
                unsigned int color)
{
int i,j;

for (i=x1;i<x2;i++)
  for (j=y1;j<y2;j++)
    plot (i,j,color);
}

void show_leds(unsigned int value)
{
addr_hi = 0xff;
addr_lo = 0x07;
data = value;
}

int pn_sequence(unsigned int value)
// Takes a PN sequence value, and produces the next value...
{
return((value << 1) + (((value>>2) ^ (value>>7))&0x01));
}

main() {
int rand;
int a, x1,x2,y1,y2,color,temp;
long b;

// Clear the screen
  fill_block(0,0,128,96,0);

// Try to make a PN generator...
rand = 0xf0;

while (1) {
  rand = pn_sequence(rand);
  x1 = rand;
  rand = pn_sequence(rand);
  x2 = rand;
  rand = pn_sequence(rand);
  y1 = rand;
  rand = pn_sequence(rand);
  y2 = rand;
  rand = pn_sequence(rand);
  color = rand;
  x1 = x1 >> 1;
  x2 = x2 >> 1;
  // Implement various checks to ensure that the coordinates
  // are properly sized for drawing rectangles.
  if (y1 > 95) y1 = 85;
  if (y2 > 95) y2 = 95;
  if (x1 > 126) x1 = 1;
  if (x2 > 126) x2 = 120;
  if (x1 == x2) x2+=10;
  else if (x1>x2) {
	  temp = x1;
	  x1 = x2;
	  x2 = temp;
  }
  if (y1 == y2) y2+= 12;
  else if (y1>y2) {
	  temp = y1;
	  y1 = y2;
	  y2 = temp;
  }
  fill_block(x1,y1,x2,y2,color);
  // Delay for debug
  for (a=0;a<8;a++)
    for (b=0;b<16000;b++) {}
  show_leds(rand);
} // End of while loop

}
