LIBRARY ieee;
USE IEEE.std_logic_1164.ALL;
USE IEEE.numeric_std.ALL;
USE WORK.enkrip_pack.ALL;

ENTITY KeyExpander IS
  PORT (clock_i       : in std_logic;    					  -- sinyal clock_i 
        reset_i       : in std_logic;    					  -- aktif high reset_i 

        kunci_load_i  : in std_logic;    					  -- load kunci baru
        start_i       : in std_logic;    					  -- mulai expand	  
		kunci_i	      : in bit128; 	  -- kunci			
		round_kunci_o : out tipe_kunci   					  -- round kunci  
  );
END KeyExpander;

ARCHITECTURE KeyExpander_RTL OF KeyExpander IS

COMPONENT ram256x8 IS
	port (
	addra: IN std_logic_VECTOR(7 downto 0);
	clka: IN std_logic;
	addrb: IN std_logic_VECTOR(7 downto 0);
	clkb: IN std_logic;
	doa: OUT std_logic_VECTOR(7 downto 0);
	dob: OUT std_logic_VECTOR(7 downto 0));
END COMPONENT;


COMPONENT BankReg IS
	PORT(clock_i	: in std_logic;
		 data_i		: in reg_w;
		 data_o		: out reg_w
	);
END COMPONENT;

TYPE tipe_state IS  (hold, kunci_expand, done);

SIGNAL sig_round_step : INTEGER RANGE 0 TO 9; 
SIGNAL sig_state   	  : tipe_state;				
SIGNAL sig_w          : reg_w;							
SIGNAL sig_kunci_map  : reg_w;						
SIGNAL x1, x2, x3, x4 : bit8;
SIGNAL sig_tmp 		  : reg_w;
SIGNAL sig_bank		  : reg_w;
begin

--Format kunci std_logic_vector(127 downto 0) diubah ke array kolom
A : FOR i IN -4 TO -1 GENERATE
  		 sig_kunci_map(i) <= kunci_i(127 - (i + 4) * 32 DOWNTO 96 - (i + 4) * 32);
	 END GENERATE;

--Output Kunci Round
B1 : FOR kolom IN 0 TO 3 GENERATE
   B2 : FOR baris IN 0 TO 3 GENERATE
	       round_kunci_o(baris)(kolom) <= sig_kunci_map(-4 + kolom)(31 - baris*8 DOWNTO 24 - baris*8) WHEN
						                (kunci_load_i = '1' OR start_i = '1' )
						  		   	    ELSE sig_w(-4 + kolom)(31 - baris*8 DOWNTO 24 - baris*8);
		 END GENERATE;
	 END GENERATE;
 
	sig_tmp <= sig_kunci_map WHEN(sig_state = hold OR sig_state = done) ELSE sig_w;
		
-- Aliran data	
	C1 : ram256x8 PORT MAP(sig_tmp(-1)(31 DOWNTO 24), clock_i, sig_tmp(-1)(23 downto 16), clock_i, x1, x2);
	C2 : ram256x8 PORT MAP(sig_tmp(-1)(15 DOWNTO 8), clock_i, sig_tmp(-1)(7 downto 0), clock_i, x3, x4);

	Ba1 : BankReg PORT MAP(clock_i, sig_tmp, sig_bank);

	sig_w <= kunci_expand(x1, x2, x3, x4, sig_round_step, sig_bank );



--Internal State Machine
PROCESS( clock_i, reset_i )

BEGIN

   IF reset_i = '1' THEN
   	sig_round_step <= 0;
    sig_state      <= hold;

   ELSIF clock_i'EVENT AND clock_i = '1' THEN
      CASE sig_state IS
         WHEN hold =>
	      	IF start_i = '1' THEN
   	        	sig_state <= kunci_expand;
            ELSE
            	sig_state <= hold;
            END IF;
            
	        sig_round_step <= 0;

         WHEN kunci_expand =>
            IF (sig_round_step /= 9 ) THEN -- cek round terakhir
	            sig_round_step  <= sig_round_step + 1;     
   	         	sig_state  		<= sig_state;
	        ELSE                            
                sig_state      <= done;
                sig_round_step <= 0;
            END IF;

         WHEN done =>
	        IF start_i = '1' THEN
   	        	sig_state <= kunci_expand;
            ELSE
                sig_state <= done;
            END IF;
                        
	         sig_round_step <= 0;
      END CASE;
                                             
   END IF; 
END PROCESS; 

END KeyExpander_RTL;









