-- Author  : John D P Purba
-- Purpose : PACKAGE

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.numeric_std.ALL;

PACKAGE enkrip_pack IS

SUBTYPE bit4		IS std_logic_vector(3 DOWNTO 0);
SUBTYPE bit8		IS std_logic_vector(7 DOWNTO 0);
SUBTYPE bit16		IS std_logic_vector(15 DOWNTO 0);
SUBTYPE bit32		IS std_logic_vector(31 DOWNTO 0);
SUBTYPE bit128		IS std_logic_vector(127 DOWNTO 0);

TYPE baris_state	IS ARRAY(0 TO 3) OF bit8;
TYPE tipe_state		IS ARRAY(0 TO 3) OF baris_state;
TYPE tipe_shift     IS ARRAY(0 TO 3) OF integer range 0 to 3;
TYPE tipe_temp      IS ARRAY(0 TO 3) OF bit8;
TYPE baris_kunci	IS ARRAY(0 TO 3) OF bit8;
TYPE tipe_kunci     IS ARRAY(0 TO 3) OF baris_kunci;
TYPE reg_w          IS ARRAY(-4 TO -1) OF bit32;
TYPE tipe_rcon      IS ARRAY(0 TO 10) OF bit8;

-- Offset Fungsi ShiftRow
CONSTANT SHIFT : tipe_shift := (
 0, 1, 2, 3);


-- Konstanta Round
CONSTANT Rcon : tipe_rcon := (
X"01", X"02", X"04", X"08", X"10", X"20", X"40", X"80", X"1b", X"36", X"00"
);


-- Deklarasi Fungsi-Fungsi
FUNCTION add_roundkey ( roundkey : tipe_kunci;
                        state    : tipe_state )
                        RETURN tipe_state;
                                   						  
FUNCTION shift_row(state : tipe_state)
                   RETURN tipe_state;

FUNCTION mix_column(state : tipe_state)
                    RETURN tipe_state;
                            
FUNCTION poly_mul(a : bit8;
                  b : bit8 )
                  RETURN std_logic_vector;
                  
                  
FUNCTION kunci_expand(byte1 : bit8;
					  byte2 : bit8;
					  byte3 : bit8;
					  byte4 : bit8;
					  i		: integer;
					  sub_k	: reg_w)
					  RETURN reg_w;
					                 
								  
END enkrip_pack;


PACKAGE BODY enkrip_pack IS

------------------------------------------------------------------------------------------
-- Fungsi AddRoundKey(key,state);
------------------------------------------------------------------------------------------
FUNCTION add_roundkey( roundkey : tipe_kunci;
                       state    : tipe_state)
                       RETURN tipe_state IS

VARIABLE b      : tipe_state;

BEGIN

   FOR baris IN 0 TO 3 LOOP
      FOR kolom IN 0 TO 3 LOOP
         b(baris)(kolom) := state(baris)(kolom) XOR roundkey(baris)(kolom);
      END LOOP;
   END LOOP;

   RETURN b;

END add_roundkey;


------------------------------------------------------------------------------------------
--Fungsi ShiftRow(state);
------------------------------------------------------------------------------------------
FUNCTION shift_row(state : tipe_state) 
                   RETURN tipe_state IS

VARIABLE a      : tipe_state;
VARIABLE temp   : tipe_temp;

BEGIN

   a := state;        
   FOR baris IN 1 TO 3 LOOP

      FOR kolom IN 0 TO 3 LOOP
         temp(kolom) := a(baris)((kolom + shift(baris)) mod 4);
      END LOOP;

      FOR kolom IN 0 TO 3 LOOP
         a(baris)(kolom) := temp(kolom);
      END LOOP;

   END LOOP;

   RETURN a;

END shift_row;

------------------------------------------------------------------------------------------
--Fungsi MixColumn(state);
------------------------------------------------------------------------------------------
FUNCTION mix_column( state : tipe_state )
                     RETURN tipe_state IS

VARIABLE b      : tipe_state;

BEGIN

   FOR baris IN 0 TO 3 LOOP
      FOR kolom IN 0 TO 3 LOOP

         b(baris)(kolom) :=
            poly_mul("00000010", state(baris)(kolom) ) XOR
            poly_mul("00000011", state((baris + 1) mod 4)(kolom) ) XOR
            state ((baris + 2) mod 4)(kolom) XOR
            state ((baris + 3) mod 4)(kolom);

      END LOOP;
   END LOOP;

   RETURN b;

END mix_column;      

------------------------------------------------------------------------------------------------
--Fungsi Perkalian State dengan polinom empat suku tetap a(x) = {03}x^3 + {01}x^2 + {01}x + {02}
------------------------------------------------------------------------------------------------
FUNCTION poly_mul(a : bit8;
                  b : bit8 )
                  RETURN std_logic_vector IS



VARIABLE temp     : bit8;
VARIABLE and_mask : bit8;


BEGIN

   and_mask := b(7) & b(7) & b(7) & b(7) & b(7) & b(7) & b(7) & b(7);

   CASE a(3 DOWNTO 0) IS
      WHEN "0010" =>
         temp := (b(6 DOWNTO 0) & '0') XOR (("00011011") AND and_mask);

      WHEN "0011"=>
         temp := (b(6 DOWNTO 0) & '0') XOR (("00011011") AND and_mask) XOR b;

      WHEN OTHERS =>
         temp := ( OTHERS => '0' );

   END CASE;

   RETURN temp;
 
END poly_mul;

FUNCTION kunci_expand(byte1 : bit8;
					  byte2 : bit8;
					  byte3 : bit8;
					  byte4 : bit8;
					  i		: integer;
					  sub_k	: reg_w)
					  RETURN reg_w IS
					  
VARIABLE sub_kunci : reg_w;
VARIABLE temp1 	   : bit32;
VARIABLE temp2 	   : bit32;

BEGIN

	FOR index IN -4 TO -1 LOOP
   		sub_kunci(index) := sub_k(index);	
	END LOOP;

	temp1 := byte2 & byte3 & byte4 & byte1;

	temp2 := temp1 XOR sub_k(-4) XOR rcon(i) & X"000000";

	sub_kunci(-4) := temp2;

	sub_kunci(-3) := sub_kunci(-4) XOR sub_kunci(-3);

	sub_kunci(-2) := sub_kunci(-3) XOR sub_kunci(-2);

	sub_kunci(-1) := sub_kunci(-2) XOR sub_kunci(-1);

	RETURN sub_kunci;				  
	
END kunci_expand;

END enkrip_pack;							   							 						



















