-- Author  : John D P Purba
-- Purpose : Core Enkripsi

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE WORK.enkrip_pack.ALL;

ENTITY CoreEnkripsi IS
  PORT (clock_i     	: IN std_logic;
        reset_i     	: IN std_logic;

        data_in_i  	: IN bit32;    
        data_load_i : IN std_logic;  
        kunci_in_i  : IN bit32;   
        kunci_load_i: IN std_logic; 
        data_out_o	: OUT bit32;  
        done_o      : OUT std_logic
  );
END CoreEnkripsi;

ARCHITECTURE Struktur of CoreEnkripsi IS

COMPONENT Kontroler IS
	PORT(clock_i	   : IN std_logic;
 		 reset_i	   : IN std_logic;

		 start_i       : IN std_logic;	
		 mux_sel_o     : OUT std_logic;
		 mix_sel_o     : OUT std_logic;
		 add_sel_o     : OUT std_logic;
		 kunci_start_o : OUT std_logic
	);
END COMPONENT;

COMPONENT BlokInput IS
	PORT(clock_i  : IN std_logic;
		 reset_i  : IN std_logic;
		 
		 en_i	  : IN std_logic;
		 data_i   : IN bit32;
		 data_o   : OUT bit128;
		 load_o   : OUT std_logic
	);
END COMPONENT;

COMPONENT KeyExpander IS
  PORT (clock_i       : in std_logic;    					  -- sinyal clock_i 
        reset_i       : in std_logic;    					  -- aktif high reset_i 

        kunci_load_i  : in std_logic;    					  -- load kunci baru
        start_i       : in std_logic;    					  -- mulai expand	  
		kunci_i	      : in bit128; 	  -- kunci			
		round_kunci_o : out tipe_kunci   					  -- round kunci  
  );
END COMPONENT;

COMPONENT Rounding IS
	PORT(clock_i	   : IN std_logic;

  		 data_i        : IN bit128;		-- PlainText
		 round_kunci_i : IN tipe_kunci;	-- Kunci	  
		 mux_sel_i     : IN std_logic;  -- Sinyal selektor multiplexer
		 mix_sel_i     : IN std_logic;	-- Sinyal aktifasi blok MixColumn
		 add_sel_i     : IN std_logic;	-- Sinyal aktifasi blok AddRoundKey
		 data_o        : OUT bit128		-- CipherText
	);
END COMPONENT;

COMPONENT BlokOutput IS
	PORT(clock_i  : IN std_logic;
		 reset_i  : IN std_logic;
		 
		 en_i	  : IN std_logic;
		 data_i   : IN bit128;
		 data_o   : OUT bit32;
		 valid_o  : OUT std_logic
	);
END COMPONENT;


SIGNAL sig_datain     : bit128;        
SIGNAL sig_dataload   : std_logic;      
SIGNAL sig_kunciload  : std_logic;      
SIGNAL sig_kunci      : bit128;        
SIGNAL sig_roundkunci : tipe_kunci;       
SIGNAL sig_rounddata  : bit128;
SIGNAL sig_muxsel     : std_logic;
SIGNAL sig_mixsel     : std_logic;
SIGNAL sig_addsel     : std_logic;
SIGNAL sig_kuncistart : std_logic;
   


BEGIN                                                                                                                                                                                                                             

L1 : BlokInput PORT MAP(clock_i, reset_i, data_load_i, data_in_i, sig_datain, sig_dataload);

L2 : BlokInput PORT MAP(clock_i, reset_i, kunci_load_i, kunci_in_i, sig_kunci, sig_kunciload);

L3 : Kontroler PORT MAP(clock_i, reset_i, sig_dataload, sig_muxsel, sig_mixsel, sig_addsel, sig_kuncistart);

L4 : Rounding PORT MAP (clock_i,  sig_datain, sig_roundkunci, sig_muxsel, sig_mixsel, sig_addsel, sig_rounddata);

L5 : KeyExpander PORT MAP (clock_i, reset_i, sig_kunciload, sig_kuncistart, sig_kunci, sig_roundkunci); 

L6 : BlokOutput PORT MAP(clock_i, reset_i, sig_addsel, sig_rounddata, data_out_o, done_o);

END Struktur;



