-- Author  : John D P Purba
-- Purpose : Blok Register Input

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE WORK.enkrip_pack.ALL;

ENTITY BlokInput IS
	PORT(clock_i  : IN std_logic;
		 reset_i  : IN std_logic;
		 
		 en_i	  : IN std_logic;
		 data_i   : IN bit32;
		 data_o   : OUT bit128;
		 load_o   : OUT std_logic
	);
END BlokInput;

ARCHITECTURE Struktur of BlokInput IS

COMPONENT FSMInput IS 
	PORT(clock_i	 : IN std_logic;
		 reset_i 	 : IN std_logic;

		 en_i	 : IN std_logic;
		 load_o  : OUT std_logic
	);
END COMPONENT;

COMPONENT Reg32i IS
	PORT(clock_i	 : IN std_logic;
		 reset_i 	 : IN std_logic;

		 en_i	 : IN std_logic;
		 data_i	 : IN bit32;
		 data_o  : OUT bit32
	);
END COMPONENT;

SIGNAL sig_out1	: bit32;
SIGNAL sig_out2	: bit32;
SIGNAL sig_out3	: bit32;
SIGNAL sig_out4	: bit32;

BEGIN 

Reg1 : Reg32i PORT MAP(clock_i, reset_i, en_i, data_i, sig_out1);

Reg2 : Reg32i PORT MAP(clock_i, reset_i, en_i, sig_out1, sig_out2);

Reg3 : Reg32i PORT MAP(clock_i, reset_i, en_i, sig_out2, sig_out3);

Reg4 : Reg32i PORT MAP(clock_i, reset_i, en_i, sig_out3, sig_out4);

FSM1 : FSMInput PORT MAP(clock_i, reset_i, en_i, load_o);

data_o <= sig_out4 & sig_out3 & sig_out2 & sig_out1;

END Struktur;







