LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE WORK.enkrip_pack.ALL;

ENTITY ByteSub IS
    port (clock_i : in std_logic;
    	  byte_i  : in tipe_state;
          byte_o  : out tipe_state
    );
END ByteSub;

ARCHITECTURE ByteSub_arch OF ByteSub IS

component ram256x8 IS
	port (
	addra: IN std_logic_VECTOR(7 downto 0);
	clka: IN std_logic;
	addrb: IN std_logic_VECTOR(7 downto 0);
	clkb: IN std_logic;
	doa: OUT std_logic_VECTOR(7 downto 0);
	dob: OUT std_logic_VECTOR(7 downto 0));
end component;

BEGIN
R1 : ram256x8 port map(addra => byte_i(0)(0), clka => clock_i,
					   addrb => byte_i(0)(1), clkb => clock_i,
					   doa => byte_o(0)(0), dob => byte_o(0)(1));
					   
R2 : ram256x8 port map(addra => byte_i(0)(2), clka => clock_i,
					   addrb => byte_i(0)(3), clkb => clock_i,
					   doa => byte_o(0)(2), dob => byte_o(0)(3));

R3 : ram256x8 port map(addra => byte_i(1)(0), clka => clock_i,
					   addrb => byte_i(1)(1), clkb => clock_i,
					   doa => byte_o(1)(0), dob => byte_o(1)(1));

R4 : ram256x8 port map(addra => byte_i(1)(2), clka => clock_i,
					   addrb => byte_i(1)(3), clkb => clock_i,
					   doa => byte_o(1)(2), dob => byte_o(1)(3));

R5 : ram256x8 port map(addra => byte_i(2)(0), clka => clock_i,
					   addrb => byte_i(2)(1), clkb => clock_i,
					   doa => byte_o(2)(0), dob => byte_o(2)(1));

R6 : ram256x8 port map(addra => byte_i(2)(2), clka => clock_i,
					   addrb => byte_i(2)(3), clkb => clock_i,
					   doa => byte_o(2)(2), dob => byte_o(2)(3));

R7 : ram256x8 port map(addra => byte_i(3)(0), clka => clock_i,
					   addrb => byte_i(3)(1), clkb => clock_i,
					   doa => byte_o(3)(0), dob => byte_o(3)(1));

R8 : ram256x8 port map(addra => byte_i(3)(2), clka => clock_i,
					   addrb => byte_i(3)(3), clkb => clock_i,
					   doa => byte_o(3)(2), dob => byte_o(3)(3));
					   
				   
END ByteSub_arch;
