`include	"nnARMCore.v"
`include	"WishBone_Arbiter.v"
`include	"I_Bus2Core.v"
`include	"D_Bus2Core.v"
`include	"MemoryController_WB_Beh.v"

module nnARM(Fiq,Irq,clock,reset);

input Fiq,Irq,clock,reset;

//signal between I_Bus2Core and IF
wire	I_Bus2Core_Wait;	//if fetch ready?
wire	[`InstructionWidth-1:0]	I_Bus2Core_Instruction;	//fetch back instruction
wire	[`AddressBusWidth-1:0]	I_Bus2Core_InstructionAddress;	//send out fetch address

//signal between mem and D_Bus2Core
wire	[`AddressBusWidth-1:0]	D_Bus2Core_Address;	//data address
wire	[`WordWidth-1:0]	D_Bus2Core_Bus_r,D_Bus2Core_Bus_f;	//data value for write and read
wire	D_Bus2Core_Request;	//enable access
wire	D_Bus2Core_BW;	//1 means byte,0 means word
wire	D_Bus2Core_RW;	//1 means read,0 means write
wire	D_Bus2Core_Wait;	//wait for free	

//signal of instruction wishbone interface
wire	I_wb_ack_i;
wire	[`AddressBusWidth-1:0]	I_wb_addr_o;
wire	I_wb_cyc_o;
wire	[`WordWidth-1:0]	I_wb_data_i;
wire	[`WordWidth-1:0]	I_wb_data_o;
wire	I_wb_err_i;
wire	I_wb_rty_i;
wire	[7:0]	I_wb_sel_o;
wire	I_wb_stb_o;
wire	I_wb_we_o;

//signal of data wishbone interface
wire	D_wb_ack_i;
wire	[`AddressBusWidth-1:0]	D_wb_addr_o;
wire	D_wb_cyc_o;
wire	[`WordWidth-1:0]	D_wb_data_i;
wire	[`WordWidth-1:0]	D_wb_data_o;
wire	D_wb_err_i;
wire	D_wb_rty_i;
wire	[7:0]	D_wb_sel_o;
wire	D_wb_stb_o;
wire	D_wb_we_o;

//grant signal for the two master
wire	D_wb_gnt,D_wb_gnt;

//wishbone clock and reset
wire	wb_clk_i,wb_rst_i;

//common signal
//forward signal that goto slave
wire	[`AddressBusWidth-1:0]	com_addr_f;
wire	com_cyc_f,com_stb_f,com_we_f;
wire	[`WordWidth-1:0]	com_data_f;
wire	[7:0]	com_sel_f;

//reverse signal that goto master
wire	com_ack_r,com_err_r;
wire	[`WordWidth-1:0]	com_data_r;

//select reverse signal into master
wire	I_wb_ack_i,D_wb_ack_i,I_wb_err_i,D_wb_err_i,I_wb_rty_i,D_wb_rty_i;
wire	[`WordWidth-1:0]	I_wb_data_i,D_wb_data_i;

//memory controller output signal
wire	[`WordWidth-1:0]	wb_data_o_memctl;
wire	wb_ack_o_memctl,wb_err_o_memctl;

nnARMCore	inst_nnARMCore(//signal between I_Bus2Core and IF
		.Wait(I_Bus2Core_Wait),			//if fetch ready?
		.Instruction(I_Bus2Core_Instruction),		//fetch back instruction
		.out_InstructionAddress(I_Bus2Core_InstructionAddress),	//send out fetch address
		//signal between mem and D_Bus2Core
		.out_MEMAccessAddress(D_Bus2Core_Address),		//data address
		.DataBus_r(D_Bus2Core_Bus_r),		//data value for write and read
		.DataBus_f(D_Bus2Core_Bus_f),
		.out_MEMAccessRequest(D_Bus2Core_Request),	//enable access
		.out_MEMAccessBW(D_Bus2Core_BW),			//1 means byte,0 means word
		.out_MEMAccessRW(D_Bus2Core_RW),			//1 means read,0 means write
		.out_DataCacheWait(D_Bus2Core_Wait),		//wait for free	
		//interrupt signal
		.Fiq(Fiq),
		.Irq(Irq),
		.clock(clock),
		.reset(reset)
		);

I_Bus2Core	inst_I_Bus2Core(//signal between I_Bus2Core and IF
		.IWait(I_Bus2Core_Wait),			//if fetch ready?
		.Instruction(I_Bus2Core_Instruction),		//fetch back instruction
		.in_InstructionAddress(I_Bus2Core_InstructionAddress),	//send out fetch address
		//signal goto wishbone
		.wb_ack_i(I_wb_ack_i),
		.wb_addr_o(I_wb_addr_o),
		.wb_cyc_o(I_wb_cyc_o),
		.wb_data_i(I_wb_data_i),
		.wb_data_o(I_wb_data_o),
		.wb_err_i(I_wb_err_i),
		.wb_rty_i(I_wb_rty_i),
		.wb_sel_o(I_wb_sel_o),
		.wb_stb_o(I_wb_stb_o),
		.wb_we_o(I_wb_we_o),
		.clk_i(clock),
		.rst_i(~reset)
);

D_Bus2Core	inst_D_Bus2Core(//signal between mem and D_Bus2Core
		.in_MEMAccessAddress(D_Bus2Core_Address),		//data address
		.out_DataCacheBus(D_Bus2Core_Bus_r),		//data value for write and read
		.in_DataCacheBus(D_Bus2Core_Bus_f),		//data value for write and read
		.in_MEMAccessRequest(D_Bus2Core_Request),	//enable access
		.in_MEMAccessBW(D_Bus2Core_BW),			//1 means byte,0 means word
		.in_MEMAccessRW(D_Bus2Core_RW),			//1 means read,0 means write
		.out_DataCacheWait(D_Bus2Core_Wait),		//wait for free	
		//signal goto wishbone
		.wb_ack_i(D_wb_ack_i),
		.wb_addr_o(D_wb_addr_o),
		.wb_cyc_o(D_wb_cyc_o),
		.wb_data_i(D_wb_data_i),
		.wb_data_o(D_wb_data_o),
		.wb_err_i(D_wb_err_i),
		.wb_rty_i(D_wb_rty_i),
		.wb_sel_o(D_wb_sel_o),
		.wb_stb_o(D_wb_stb_o),
		.wb_we_o(D_wb_we_o),
		.clk_i(clock),
		.rst_i(~reset)
);

WishBone_Arbiter	inst_WishBone_Arbiter(
		//some cyc signal from mater,1 with the highest right
		.wb_cyc_1(D_wb_cyc_o),
		.wb_cyc_2(I_wb_cyc_o),
		//who can access
		.wb_gnt_1(D_wb_gnt),
		.wb_gnt_2(I_wb_gnt),
		.clk_i(clock),
		.rst_i(~reset)
);

//these device use wb_gnt_x signal to select other wishbone signal
//forward signal that goto slave
assign	com_addr_f=(D_wb_gnt==1'b1)?D_wb_addr_o:I_wb_addr_o;
assign	com_cyc_f=(D_wb_gnt & D_wb_cyc_o) | (I_wb_gnt & I_wb_cyc_o);
assign	com_data_f=(D_wb_gnt==1'b1)?D_wb_data_o:I_wb_data_o;
assign	com_sel_f=(D_wb_gnt==1'b1)?D_wb_sel_o:I_wb_sel_o;
assign	com_stb_f=(D_wb_gnt & D_wb_stb_o) | (I_wb_gnt & I_wb_stb_o);
assign	com_we_f=(D_wb_gnt==1'b1)?D_wb_we_o:I_wb_we_o;

//reverse signal that goto master
assign	com_ack_r=wb_ack_o_memctl;
assign	com_data_r=wb_data_o_memctl;
assign	com_err_r=wb_err_o_memctl;

//select reverse signal into master
assign	I_wb_ack_i=I_wb_gnt & com_ack_r;
assign	D_wb_ack_i=D_wb_gnt & com_ack_r;
assign	I_wb_data_i=com_data_r;
assign	D_wb_data_i=com_data_r;
assign	I_wb_err_i=com_err_r;
assign	D_wb_err_i=com_err_r;
assign	I_wb_rty_i=1'b0;
assign	D_wb_rty_i=1'b0;


MemoryController_WB_Bhv	inst_MemoryController_WB_Bhv(//wishbone global signal
				.clk_i(clock),	//wishbone clock from syscon
				.rst_i(~reset),	//wishbone reset from syscon
				//wishbone interface
				.wb_addr_i(com_addr_f),	//32 bit address input
				.wb_data_i(com_data_f),	//32 bit data input
				.wb_data_o(wb_data_o_memctl),	//32 bit data output
				.wb_sel_i(com_sel_f),	//4 bits input Indicates which bytes are valid on the data bus
				.wb_we_i(com_we_f),	//1 bit write enable
				.wb_cyc_i(com_cyc_f),	// 1 bit Encapsulates a valid transfer cycle
				.wb_stb_i(com_stb_f),	//1 bit Indicates a valid transfer.
				.wb_ack_o(wb_ack_o_memctl),	//1 bit Indicates a normal Cycle termina-tion
				.wb_err_o(wb_err_o_memctl)	//1 bit Indicates an abnormal cycle termination
);
endmodule