module	WishBone_Arbiter(//some cyc signal from mater,1 with the highest right
		wb_cyc_1,
		wb_cyc_2,
		//who can access
		wb_gnt_1,
		wb_gnt_2,
		clk_i,
		rst_i
);

input	wb_cyc_1,wb_cyc_2;

output	wb_gnt_1,wb_gnt_2;

input	clk_i,rst_i;

reg	[1:0]	State;
reg	[1:0]	Next_State;

always	@(State	or
	wb_cyc_2	or
	wb_cyc_1
)
begin
	case(State)
	2'b00:
		case({wb_cyc_2,wb_cyc_1})
		2'b00:
			Next_State=2'b00;
		2'b10:
			Next_State=2'b10;
		default:
			Next_State=2'b01;
		endcase
	2'b01:
		case({wb_cyc_2,wb_cyc_1})
		2'b00:
			Next_State=2'b00;
		2'b10:
			Next_State=2'b10;
		default:
			Next_State=2'b01;
		endcase
	2'b10:
		case({wb_cyc_2,wb_cyc_1})
		2'b00:
			Next_State=2'b00;
		2'b01:
			Next_State=2'b01;
		default:
			Next_State=2'b10;
		endcase
	default:
		Next_State=2'b00;
	endcase
end

always	@(posedge clk_i or posedge rst_i)
begin
	if(rst_i==1'b1)	//wishbone reset active high
		State=2'b00;
	else
		State=Next_State;
end

assign	{wb_gnt_2,wb_gnt_1}=State;
endmodule