module MemoryController_WB_Bhv(//wishbone global signal
				clk_i,	//wishbone clock from syscon
				rst_i,	//wishbone reset from syscon
				//wishbone interface
				wb_addr_i,	//32 bit address input
				wb_data_i,	//32 bit data input
				wb_data_o,	//32 bit data output
				wb_sel_i,	//4 bits input Indicates which bytes are valid on the data bus
				wb_we_i,	//1 bit write enable
				wb_cyc_i,	// 1 bit Encapsulates a valid transfer cycle
				wb_stb_i,	//1 bit Indicates a valid transfer.
				wb_ack_o,	//1 bit Indicates a normal Cycle termina-tion
				wb_err_o	//1 bit Indicates an abnormal cycle termination
);
input clk_i,rst_i;

input	[31:0]	wb_addr_i,wb_data_i;

output	[31:0]	wb_data_o;

input	[7:0]	wb_sel_i;

input	wb_we_i,wb_cyc_i,wb_stb_i;

output	wb_ack_o,wb_err_o;


reg	[31:0]	wb_data_o;
reg	wb_ack_o,wb_err_o;


reg 	[7:0]	Memory	[1024*1024-1:0];
wire	[31:0]	test;
assign	test={Memory[32'h8027],Memory[32'h8026],Memory[32'h8025],Memory[32'h8024]};
//read
always @(wb_cyc_i	or
	wb_stb_i	or
	wb_we_i	or
	wb_addr_i	or
	wb_data_i
)
begin
	if(wb_cyc_i==1'b1 && wb_stb_i==1'b1)
	begin
	   if(wb_we_i==1'b0)	//read
	   begin
		if(wb_addr_i[31:20]==12'h000)	//address in my address space
		begin
			if(wb_sel_i==8'h01)
				wb_data_o={24'h000000,Memory[{12'h000,wb_addr_i[19:0]}]};
			else if(wb_sel_i==8'h0f)
				wb_data_o={Memory[{12'h000,wb_addr_i[19:2],2'b11}],Memory[{12'h000,wb_addr_i[19:2],2'b10}],Memory[{12'h000,wb_addr_i[19:2],2'b01}],Memory[{12'h000,wb_addr_i[19:2],2'b00}]};
			else
				wb_data_o={16'h0000,Memory[{12'h000,wb_addr_i[19:1],1'b1}],Memory[{12'h000,wb_addr_i[19:1],1'b0}]};
				
			wb_ack_o=1'b1;
			wb_err_o=1'b0;
		end
		else				//address is not in my space
		begin
			wb_data_o=`WordZero;
			wb_ack_o=1'b0;
			wb_err_o=1'b0;
		end
	   end
	   else			//write
	   begin
		if(wb_addr_i[31:20]==12'h000)	//address in my address space
		begin
			wb_ack_o=1'b1;
			wb_err_o=1'b0;
			wb_data_o=`WordZero;
		end
		else				//address is not in my space
		begin
			wb_ack_o=1'b0;
			wb_err_o=1'b0;
			wb_data_o=`WordZero;
		end
	   end
	end
	else
	begin
		wb_data_o=`WordZero;
		wb_ack_o=1'b0;
		wb_err_o=1'b0;
	end
end

always	@(posedge clk_i or posedge rst_i)
begin
	if(wb_we_i==1'b1 && wb_addr_i[31:20]==12'h000 && wb_cyc_i==1'b1 && wb_stb_i==1'b1)
	if(wb_sel_i==8'h01)
		Memory[{12'h000,wb_addr_i[19:0]}]=wb_data_i[7:0];
	else if(wb_sel_i==8'h0f)
		{Memory[{12'h000,wb_addr_i[19:2],2'b11}],Memory[{12'h000,wb_addr_i[19:2],2'b10}],Memory[{12'h000,wb_addr_i[19:2],2'b01}],Memory[{12'h000,wb_addr_i[19:2],2'b00}]}=wb_data_i;
	else
		{Memory[{12'h000,wb_addr_i[19:1],1'b1}],Memory[{12'h000,wb_addr_i[19:1],1'b0}]}=wb_data_i[15:0];
end
endmodule