module	D_Bus2Core(//signal between mem and D_Bus2Core
		in_MEMAccessAddress,		//data address
		out_DataCacheBus,		//data value for write and read
		in_DataCacheBus,		//data value for write and read
		in_MEMAccessRequest,	//enable access
		in_MEMAccessBW,			//1 means byte,0 means word
		in_MEMAccessRW,			//1 means read,0 means write
		out_DataCacheWait,		//wait for free	
		//signal goto wishbone
		wb_ack_i,
		wb_addr_o,//
		wb_cyc_o,//
		wb_data_i,
		wb_data_o,//
		wb_err_i,
		wb_rty_i,
		wb_sel_o,//
		wb_stb_o,//
		wb_we_o,//
		clk_i,
		rst_i
);

input	[`AddressBusWidth-1:0]	in_MEMAccessAddress;
inout	[`WordWidth-1:0]	in_DataCacheBus,out_DataCacheBus;
input	in_MEMAccessRequest,in_MEMAccessBW,in_MEMAccessRW;
output	out_DataCacheWait;

input	wb_ack_i;
output	[`AddressBusWidth-1:0]	wb_addr_o;
output	wb_cyc_o;
input	[`WordWidth-1:0]	wb_data_i;
output	[`WordWidth-1:0]	wb_data_o;
input	wb_err_i;
input	wb_rty_i;
output	[7:0]	wb_sel_o;
output	wb_stb_o;
output	wb_we_o;

input	clk_i,rst_i;


assign	wb_sel_o=(in_MEMAccessBW==1'b1)?8'h01:8'h0f;

assign	wb_addr_o=in_MEMAccessAddress;

assign	wb_cyc_o=in_MEMAccessRequest;

assign	wb_data_o=in_DataCacheBus;

assign	wb_stb_o=in_MEMAccessRequest;

assign	wb_we_o=~in_MEMAccessRW;

assign	out_DataCacheWait=(~wb_ack_i) & wb_cyc_o;

assign	out_DataCacheBus=wb_data_i;
endmodule