`include "timescalar.v"
`include "nnARM1.v"
`include "Def_StructureParameter.v"
`include "Def_SimulationParameter.v"

module tb_system;

integer ssycnt;
reg clock,reset;
reg [`InstructionWidth-1:0] TestInstruction;
wire Fiq,Irq;

nnARM inst_nnARM(
		.Fiq(Fiq),
		.Irq(Irq),
		.clock(clock),
		.reset(reset)
		);
		
initial
begin
	clock=1'b0;
	reset=1'b1;
	#10
	reset=1'b0;
	#500
	reset=1'b1;
	
end

initial
begin
	$readmemh("asc",inst_nnARM.inst_MemoryController.Memory);
	$readmemh("asc",inst_nnARM.inst_DataMemoryController.Memory);
	//$dumpfile("df");
	//$dumpvars;
	//#600000
	//$dumpflush;
	//$finish;
	//$stop;
end

always
begin
	#(`HalfClockCycle)
		clock=~clock;
end

assign	Fiq=1'b0;
assign	Irq=1'b0;


endmodule