//the lowest bit is the rest bit
//the other bits is the decoded part result
function [34:0] decode;
input [2:0] threebit;
input [33:0] amanadj;
begin
		case(threebit)
		3'b000,3'b111:	begin
				decode={34'b0000_0000_0000_0000_0000_0000_0000_0000_00,1'b0};
			end
		3'b001,3'b010:	begin
				decode={amanadj,1'b0};
			end
		3'b011:	begin
				decode={amanadj[32:0],1'b0,1'b0};
			end
		3'b100:	begin
				decode={~amanadj[32:0],1'b1,1'b1};
			end
		3'b101,3'b110:	begin
				decode={~amanadj,1'b1};
			end
		endcase

end
endfunction

function [65:0] mul;

input	[31:0]	a,b;

reg  [33:0]  amanadj;
reg  [32:0]  bmanadj;

reg  [65:0]  resultman;
reg  [33:0]  parttmp;
reg  [32:0]  rest;
integer	ssycnt;
begin
	amanadj={a[31],a[31],a};
	bmanadj={b[31],b};

	resultman=66'b0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_00;
	rest=33'b0000_0000_0000_0000_0000_0000_0000_0000_0;
	if(bmanadj[0]==1'b0)
		parttmp=34'b0000_0000_0000_0000_0000_0000_0000_0000_00;
	else
	begin
		parttmp=~amanadj;
		rest[0]=1'b1;
	end
	resultman[65:32]=resultman[65:32]+parttmp;
	resultman={resultman[65],resultman[65:1]};


	//ssycnt==1 ,shift 2 bits
	{parttmp,rest[1]}=decode(bmanadj[2:0],amanadj);
	resultman[65:32]=resultman[65:32]+parttmp;
	resultman={resultman[65],resultman[65],resultman[65:2]};

	//ssycnt==3 ,shift 2 bits
	{parttmp,rest[3]}=decode(bmanadj[4:2],amanadj);
	resultman[65:32]=resultman[65:32]+parttmp;
	resultman={resultman[65],resultman[65],resultman[65:2]};

	//ssycnt==5 ,shift 2 bits
	{parttmp,rest[5]}=decode(bmanadj[6:4],amanadj);
	resultman[65:32]=resultman[65:32]+parttmp;
	resultman={resultman[65],resultman[65],resultman[65:2]};

	//ssycnt==7 ,shift 2 bits
	{parttmp,rest[7]}=decode(bmanadj[8:6],amanadj);
	resultman[65:32]=resultman[65:32]+parttmp;
	resultman={resultman[65],resultman[65],resultman[65:2]};

	//ssycnt==9 ,shift 2 bits
	{parttmp,rest[9]}=decode(bmanadj[10:8],amanadj);
	resultman[65:32]=resultman[65:32]+parttmp;
	resultman={resultman[65],resultman[65],resultman[65:2]};

	//ssycnt==11 ,shift 2 bits
	{parttmp,rest[11]}=decode(bmanadj[12:10],amanadj);
	resultman[65:32]=resultman[65:32]+parttmp;
	resultman={resultman[65],resultman[65],resultman[65:2]};

	//ssycnt==13 ,shift 2 bits
	{parttmp,rest[13]}=decode(bmanadj[14:12],amanadj);
	resultman[65:32]=resultman[65:32]+parttmp;
	resultman={resultman[65],resultman[65],resultman[65:2]};

	//ssycnt==15 ,shift 2 bits
	{parttmp,rest[15]}=decode(bmanadj[16:14],amanadj);
	resultman[65:32]=resultman[65:32]+parttmp;
	resultman={resultman[65],resultman[65],resultman[65:2]};

	//ssycnt==17 ,shift 2 bits
	{parttmp,rest[17]}=decode(bmanadj[18:16],amanadj);
	resultman[65:32]=resultman[65:32]+parttmp;
	resultman={resultman[65],resultman[65],resultman[65:2]};

	//ssycnt==19 ,shift 2 bits
	{parttmp,rest[19]}=decode(bmanadj[20:18],amanadj);
	resultman[65:32]=resultman[65:32]+parttmp;
	resultman={resultman[65],resultman[65],resultman[65:2]};

	//ssycnt==21 ,shift 2 bits
	{parttmp,rest[21]}=decode(bmanadj[22:20],amanadj);
	resultman[65:32]=resultman[65:32]+parttmp;
	resultman={resultman[65],resultman[65],resultman[65:2]};



	//ssycnt==23 ,just shift 2 bit
	{parttmp,rest[23]}=decode(bmanadj[24:22],amanadj);
	resultman[65:32]=resultman[65:32]+parttmp;
	resultman={resultman[65],resultman[65],resultman[65:2]};

	//ssycnt==25 ,just shift 2 bit
	{parttmp,rest[25]}=decode(bmanadj[26:24],amanadj);
	resultman[65:32]=resultman[65:32]+parttmp;
	resultman={resultman[65],resultman[65],resultman[65:2]};

	//ssycnt==27 ,just shift 2 bit
	{parttmp,rest[27]}=decode(bmanadj[28:26],amanadj);
	resultman[65:32]=resultman[65:32]+parttmp;
	resultman={resultman[65],resultman[65],resultman[65:2]};

	//ssycnt==29 ,just shift 2 bit
	{parttmp,rest[29]}=decode(bmanadj[30:28],amanadj);
	resultman[65:32]=resultman[65:32]+parttmp;
	resultman={resultman[65],resultman[65],resultman[65:2]};

	//ssycnt==31 ,just shift 1 bit
	{parttmp,rest[31]}=decode(bmanadj[32:30],amanadj);
	resultman[65:32]=resultman[65:32]+parttmp;
	resultman={resultman[65],resultman[65:1]};

	//add the rest vector
	resultman=resultman+{33'b0000_0000_0000_0000_0000_0000_0000_0000_0,rest};

	

	mul=resultman;
end
endfunction
