module	WB(//the write to register file
		out_WBWriteBus,
		out_WBWriteEnable,
		out_WBWriteTargetRegister,
		//input from mem
		in_MEMWriteEnable,
		in_MEMWriteResult,
		in_MEMWriteTargetRegister,
		clock,
		reset
		);
output	[`WordWidth-1:0]			out_WBWriteBus;
output						out_WBWriteEnable;
output	[`Def_RegisterSelectWidth-1:0]	out_WBWriteTargetRegister;

input		[`WordWidth-1:0]			in_MEMWriteResult;
input							in_MEMWriteEnable;
input		[`Def_RegisterSelectWidth-1:0]	in_MEMWriteTargetRegister;

input		clock,reset;

reg		[`WordWidth-1:0]			WBWriteBus;
reg							WBWriteEnable;
reg		[`Def_RegisterSelectWidth-1:0]	WBWriteTargetRegister;

reg		[`WordWidth-1:0]			Next_WBWriteBus;
reg							Next_WBWriteEnable;
reg		[`Def_RegisterSelectWidth-1:0]	Next_WBWriteTargetRegister;

//determine next state of pipeline register
always  @(in_MEMWriteEnable or
		in_MEMWriteResult  or
		in_MEMWriteTargetRegister)
begin
	Next_WBWriteBus=in_MEMWriteResult;
	Next_WBWriteEnable=in_MEMWriteEnable;
	Next_WBWriteTargetRegister=in_MEMWriteTargetRegister;
end

//determine the current state
always @(posedge clock or negedge reset)
begin
	if(reset==1'b0)
	begin
		WBWriteBus=`WordZero;
		WBWriteEnable=1'b0;
		WBWriteTargetRegister=`Def_LinkRegister;
	end
	else
	begin
		WBWriteBus=Next_WBWriteBus;
		WBWriteEnable=Next_WBWriteEnable;
		WBWriteTargetRegister=Next_WBWriteTargetRegister;
	end
end

//output port
assign	out_WBWriteBus=WBWriteBus;
assign	out_WBWriteEnable=WBWriteEnable;
assign	out_WBWriteTargetRegister=WBWriteTargetRegister;
endmodule