`include "Def_StructureParameter.v"
`include "Def_ALUType.v"
`include "BarrelShift.v"
`include "complementary.v"
`include "Adder.v"

module ALUComb(ALUCombResult,
		out_Carry,
		out_Zero,
		out_Neg,
		out_Overflow,
		ALUComb_ALUType,
		ALUComb_LeftOperand,
		ALUComb_RightOperand,
		ALUComb_ThirdOperand,
		ALUComb_RightOperandShiftType,
		ALUComb_RightOperandShiftCount,
		in_Carry);
`include "mul.v"

input [`ByteWidth-1:0] ALUComb_ALUType;
input [`WordWidth-1:0] ALUComb_LeftOperand,ALUComb_RightOperand,ALUComb_ThirdOperand;
input [`Def_ShiftTypeWidth-1:0] ALUComb_RightOperandShiftType;
input [`Def_ShiftCountWidth-1:0] ALUComb_RightOperandShiftCount;
input	in_Carry;

output [`WordWidth-1:0] ALUCombResult;
reg [`WordWidth-1:0] ALUCombResult;

output	out_Carry,out_Zero,out_Neg,out_Overflow;
reg	out_Carry,out_Zero,out_Neg,out_Overflow;


reg [`WordWidth-1:0] LeftTmp,RightTmp,LeftAdd,RightAdd;
reg LowCarry;

//mul result
wire	[65:0]	MULResult;

//the status from alu
wire alu_Carry,alu_Zero,alu_Neg,alu_Overflow;

//the status from barrel shifter
wire barrel_Carry;

wire [`WordWidth-1:0] ShiftResult,ComplementResult;
wire [`WordWidth-1:0] out_Result;

BarrelShift inst_BarrelShift(ShiftResult,
			barrel_Carry,
			ALUComb_RightOperand,
			ALUComb_RightOperandShiftCount,
			ALUComb_RightOperandShiftType
);

//select who is to be left operand and who is to be right operand to the adder
always @(ALUComb_LeftOperand or ALUComb_ALUType or ShiftResult)
begin
	if(ALUComb_ALUType==`ALUType_Rsb || ALUComb_ALUType==`ALUType_Rsc)
	begin
		LeftTmp=ShiftResult;
		RightTmp=ALUComb_LeftOperand;
	end
	else
	begin
		LeftTmp=ALUComb_LeftOperand;
		RightTmp=ShiftResult;
	end
end


			
complementary inst_complementary(ComplementResult,
			RightTmp);

WordAdder	inst_WordAdder(out_Result,
		alu_Carry,
		alu_Zero,
		alu_Neg,
		alu_Overflow,
		LeftAdd,
		RightAdd,
		LowCarry);
		
always @(ALUComb_ALUType or 
	ALUComb_LeftOperand	or
	ALUComb_RightOperand	or
	ALUComb_ThirdOperand	or
	LeftTmp or 
	RightTmp or 
	out_Result or 
	ComplementResult or 
	ShiftResult or
	alu_Carry or
	alu_Neg or
	alu_Zero or
	alu_Overflow or
	barrel_Carry	or
	MULResult
)
begin
	LeftAdd=`WordZero;
	RightAdd=`WordZero;
	LowCarry=1'b0;
	ALUCombResult=`WordZ;
	
	case (ALUComb_ALUType)
	`ALUType_Add:
	   begin
		LeftAdd=LeftTmp;
		RightAdd=RightTmp;
		ALUCombResult=out_Result;
		out_Carry=alu_Carry;
		out_Neg=alu_Neg;
		out_Overflow=alu_Overflow;
	   end
	`ALUType_Sub:
	   begin
		LeftAdd=LeftTmp;
		RightAdd=ComplementResult;
		ALUCombResult=out_Result;
		out_Carry=alu_Carry;
		out_Neg=alu_Neg;
		out_Overflow=alu_Overflow;
	   end
	`ALUType_And:
	   begin
		ALUCombResult=LeftTmp & RightTmp;
		out_Overflow=1'b0;
		out_Carry=barrel_Carry;
		out_Neg=ALUCombResult[31];
	   end
	`ALUType_Eor:
	   begin
		ALUCombResult=LeftTmp ^ RightTmp;
		out_Overflow=1'b0;
		out_Carry=barrel_Carry;
		out_Neg=ALUCombResult[31];
	   end
	`ALUType_Rsb:
	   begin
		LeftAdd=LeftTmp;
		RightAdd=ComplementResult;
		ALUCombResult=out_Result;
		out_Carry=alu_Carry;
		out_Neg=alu_Neg;
		out_Overflow=alu_Overflow;
	   end
	`ALUType_Adc:
	   begin
		LowCarry=in_Carry;
		LeftAdd=LeftTmp;
		RightAdd=RightTmp;
		ALUCombResult=out_Result;
		out_Carry=alu_Carry;
		out_Neg=alu_Neg;
		out_Overflow=alu_Overflow;
	   end
	`ALUType_Sbc:
	   begin
		LowCarry=in_Carry;
		LeftAdd=LeftTmp;
		RightAdd=~RightTmp;
		ALUCombResult=out_Result;
		out_Carry=alu_Carry;
		out_Neg=alu_Neg;
		out_Overflow=alu_Overflow;
	   end
	`ALUType_Rsc:
	   begin
		LowCarry=in_Carry;
		LeftAdd=LeftTmp;
		RightAdd=~RightTmp;
		ALUCombResult=out_Result;
		out_Carry=alu_Carry;
		out_Neg=alu_Neg;
		out_Overflow=alu_Overflow;
	   end
	`ALUType_Tst:
	   begin
		ALUCombResult=LeftTmp & RightTmp;
		out_Overflow=1'b0;
		out_Carry=barrel_Carry;
		out_Neg=ALUCombResult[31];
	   end
	`ALUType_Teq:
	   begin
		ALUCombResult=LeftTmp ^ RightTmp;
		out_Overflow=1'b0;
		out_Carry=barrel_Carry;
		out_Neg=ALUCombResult[31];
	   end
	`ALUType_Cmp:
	   begin
		LeftAdd=LeftTmp;
		RightAdd=ComplementResult;
		ALUCombResult=out_Result;
		out_Carry=alu_Carry;
		out_Neg=alu_Neg;
		out_Overflow=alu_Overflow;
	   end
	`ALUType_Cmn:
	   begin
		LeftAdd=LeftTmp;
		RightAdd=RightTmp;
		ALUCombResult=out_Result;
		out_Carry=alu_Carry;
		out_Neg=alu_Neg;
		out_Overflow=alu_Overflow;
	   end
	`ALUType_Orr:
	   begin
		ALUCombResult=LeftTmp | RightTmp;
		out_Overflow=1'b0;
		out_Carry=barrel_Carry;
		out_Neg=ALUCombResult[31];
	   end
	`ALUType_Mov:
	   begin
		ALUCombResult=ShiftResult;
		out_Overflow=1'b0;
		out_Carry=barrel_Carry;
		out_Neg=ALUCombResult[31];
	   end
	`ALUType_Bic:
	   begin
		ALUCombResult=LeftTmp & ~RightTmp;
		out_Overflow=1'b0;
		out_Carry=barrel_Carry;
		out_Neg=ALUCombResult[31];
	   end
	`ALUType_Mvn:
	   begin
		ALUCombResult=~RightTmp;
		out_Overflow=1'b0;
		out_Carry=barrel_Carry;
		out_Neg=ALUCombResult[31];
	   end
	`ALUType_Mul:
	   begin
		ALUCombResult=MULResult[31:0];
		out_Neg=ALUCombResult[31];
		out_Overflow=1'b0;
		out_Carry=1'b0;
	   end
	`ALUType_Mla:
	   begin
	   	LeftAdd=MULResult[31:0];
	   	RightAdd=ALUComb_ThirdOperand;
	   	ALUCombResult=out_Result;
		out_Neg=ALUCombResult[31];
		out_Overflow=1'b0;
		out_Carry=1'b0;
	   end
	endcase
	out_Zero=(ALUCombResult==32'h00000000)?1'b1:1'b0;
end

assign	MULResult=mul(ALUComb_LeftOperand,ALUComb_RightOperand);


endmodule
