`include "Def_StructureParameter.v"

module OneBitFullAdder(	out_HighCarry,
			out_Result,
			in_LeftOperand,
			in_RightOperand,
			in_LowCarry);

output out_HighCarry,out_Result;
input in_LeftOperand,in_RightOperand,in_LowCarry;

reg out_HighCarry,out_Result;

always @(in_LeftOperand or in_RightOperand or in_LowCarry)
begin
	out_HighCarry=1'b0;
	out_Result=1'b0;
	case ({in_LeftOperand,in_RightOperand,in_LowCarry})
	3'b000:
		begin
			out_HighCarry=1'b0;
			out_Result=1'b0;
		end
	3'b001:
		begin
			out_HighCarry=1'b0;
			out_Result=1'b1;
		end
	3'b010:
		begin
			out_HighCarry=1'b0;
			out_Result=1'b1;
		end
	3'b011:
		begin
			out_HighCarry=1'b1;
			out_Result=1'b0;
		end
	3'b100:
		begin
			out_HighCarry=1'b0;
			out_Result=1'b1;
		end
	3'b101:
		begin
			out_HighCarry=1'b1;
			out_Result=1'b0;
		end
	3'b110:
		begin
			out_HighCarry=1'b1;
			out_Result=1'b0;
		end
	3'b111:
		begin
			out_HighCarry=1'b1;
			out_Result=1'b1;
		end
	endcase
end

endmodule

module FourBitAdder(	out_HighCarry,
			out_Result,
			in_LeftOperand,
			in_RightOperand,
			in_LowCarry);
output out_HighCarry;
output [3:0] out_Result;
input [3:0] in_LeftOperand,in_RightOperand;
input in_LowCarry;


endmodule

module WordAdder(out_Result,
		out_Carry,
		out_Zero,
		out_Neg,
		out_Overflow,
		in_LeftOperand,
		in_RightOperand,
		in_LowCarry);

output [`WordWidth-1:0] out_Result;
output out_Carry,out_Zero,out_Neg,out_Overflow;

reg  [`WordWidth-1:0] out_Result;
reg out_Carry,out_Zero,out_Neg,out_Overflow;


input [`WordWidth-1:0] in_LeftOperand,in_RightOperand;
input in_LowCarry;

//must be one bit more than input and output
reg [`WordWidth:0] tmp;

always @(in_LeftOperand or in_RightOperand or in_LowCarry)
begin
	tmp={in_LeftOperand[`WordWidth-1],in_LeftOperand}+{in_RightOperand[`WordWidth-1],in_RightOperand}+{`WordZero,in_LowCarry};

	out_Result=tmp[`WordWidth-1:0];
	out_Carry=tmp[`WordWidth];
	if(tmp=={1'b0,`WordZero})
		out_Zero=1'b1;
	else
		out_Zero=1'b0;
	if(tmp[`WordWidth:`WordWidth-1]==2'b10 || tmp[`WordWidth:`WordWidth-1]==2'b01)
		out_Overflow=1'b1;
	else
		out_Overflow=1'b0;
	if(tmp[`WordWidth]==1'b1)
		out_Neg=1'b1;
	else
		out_Neg=1'b0;
	end
endmodule