/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.verilogp;

/** Synopsis GTECH library description. */
final class GTech {
	protected final static String prim[][] = {
	 {"GTECH_AND","A","B","Z"},
	 {"GTECH_OR","A","B","Z"},
	 {"GTECH_XOR","A","B","Z"},
	 {"GTECH_NOT","A","Z"},
	 {"GTECH_FD1","D","CP"," "," ","Q"},
	 {"GTECH_ADD_ABC","A","B","C","S","COUT"},
	 {"GTECH_ZERO","Z"},
	 {"GTECH_AND_NOT","A","B","Z"},
	 {"GTECH_OR_NOT","A","B","Z"},
	 {"GTECH_XOR_NOT","A","B","Z"},
	 {"**FFGEN**","next_state","clocked_on","force_01","force_10","Q","force_00","force_11"},
	 {"GTECH_BUF","A","Z"},
	 {"GTECH_ONE","Z"},
	};
	static final int AND = Dictionary.PRIMITIVES + 0;
	static final int OR = Dictionary.PRIMITIVES + 1;
	static final int XOR = Dictionary.PRIMITIVES + 2;
	static final int NOT = Dictionary.PRIMITIVES + 3;
	static final int FD1 = Dictionary.PRIMITIVES + 4;
	static final int ADD_ABC = Dictionary.PRIMITIVES + 5;
	static final int ZERO = Dictionary.PRIMITIVES + 6;
	static final int AND_NOT = Dictionary.PRIMITIVES + 7;
	static final int OR_NOT = Dictionary.PRIMITIVES + 8;
	static final int XOR_NOT = Dictionary.PRIMITIVES + 9;
	static final int FFGEN = Dictionary.PRIMITIVES + 10;
	static final int BUF = Dictionary.PRIMITIVES + 11;
	static final int ONE = Dictionary.PRIMITIVES + 12;
}
