/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.verilogp;

import java.util.Hashtable;

/** has all identifiers listed */
public class Dictionary {
  /** 1024 entries initially, should be enough for most applications */
	private Hashtable ht = new Hashtable(1024);
	
	/** tries to find object based on its name
	  * @param name object name
	  * @return Object found, null if no match */
	public Object get(String name) {
		return ht.get(name);
	}
	
	/** puts name in dictionary and link it with object o
		* @param name object name
		* @param o value */
	public void add(String name, Object o) {
		ht.put(name, o);
	}
	
	public int getKeyword(String name) {
		Object o = ht.get(name);
		if(o instanceof Integer) return ((Integer)o).intValue();
		return -1;
	}
	
	/** constructs new dictionary */
	public Dictionary() {
		for(int i = 0; i < keywords.length; i++ )
			ht.put(keywords[i], new Integer(i));		
		for(int i = 0; i < GTech.prim.length; i++ )
			ht.put(GTech.prim[i][0], new Integer(i + PRIMITIVES));					
	}
	
	/** all keyword that may occur */
	protected final String keywords[] = {
		"module", "endmodule", "wire", "input",
		"output", "assign"
	};
		
	protected static final int MODULE = 0;
	protected static final int ENDMODULE = 1;	
	protected static final int WIRE = 2;
	protected static final int INPUT = 3;
	protected static final int OUTPUT = 4;
	protected static final int ASSIGN = 5;
	
	protected static final int PRIMITIVES = 10;	
	protected static final int PRIMITIVES_END = 100;
}
