/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.structure;

import org.opencores.Conf;

/** Special resource node that has no routing capabilities.
  * Actually looks like a simple buffer, but it extends NodeRoutable
  * that routing can handle it */
public class NodeSR extends NodeRoutable {
	/** Constructs new resource node. Either collector or generator.
	  * @idx SR number */
	public NodeSR(int idx) {
		super(2);
		dir[1] = OUTPUT;
		fy = y = -2;
		fx = x = (Conf.X-Conf.NUM_SR)/2 + idx;
		idx = idx;
		name = "SR"+idx;
	}
	
	/** @return <b>true</b> whether connection is possible for port <code><i>port</i></code> using wire segment <code><i>segment/i></code> */
	public boolean isConnectable(int port, int segment) {
		return true;
	}
}

