/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.structure;

/** LUT cell type class. It implements some standard primitives */
public final class NodePrim extends NodeLUT {
	/** primitive */
	public static final int INV = 0;
	/** primitive */
	public static final int XOR2 = 1;
	/** primitive */
	public static final int AND2 = 2;
	/** primitive */
	public static final int OR2 = 3;
	/** primitive */
	public static final int NAND2 = 4;
	/** primitive */
	public static final int NOR2 = 5;
	/** primitive */
	public static final int GND = 6;
	/** primitive */
	public static final int VCC = 7;
	/** primitive */
	public static final int BUF = 8;	
	
	/** primitive's number of inputs */
	private static final int sizes[]=		
	{ 1, 2, 2, 2,
	  2, 2, 0, 0,
	  1, 1, 1
	};	
	/** primitive's functions */
	private static final byte funcs[]=	
	{0x01,0x06,0x08,0x0E,
	 0x07,0x01,0x00,0x01,
	 0x02,0x02,0x02
	};
	
	/** primitive's names */
	public static final String names[]={
		"INV","XOR2","AND2","OR2",
		"NAND2","NOR2","GND","VCC",
		"BUF","BUFG","IBUF"
	};
	
	/** Creates cell primitive from specified type */
	/** @param type primitive type (e.g. NodePrim.INV) */
	public NodePrim(int type) {		
		super(sizes[type]+1);	// supply number of ports
		dir[sizes[type]] = OUTPUT;
		func[0] = funcs[type];
	}
	
	public String toString() {
		return "PRIM "+super.toString();
	}
	
	/** creates new (unlinked) node with same parameters.
	  * @return duplicated node */
	public Object clone() {
		NodePrim n = new NodePrim(0);
		n.duplicate(this);
		return n;
	}
	
	/** duplicates parameters from n to this
	  * @param n node to copy data from */
	public void duplicate(NodePrim n) {
		duplicate((NodeLUT)n);
	}
}
