/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.structure;

import java.util.Vector;
import org.opencores.Conf;

/** design cell port is handled as Node */
public final class NodePort extends Node {
	
	/** Constructs new node with given direction */
	public NodePort(int direction) {
		super(1);		
		dir[0] = org.opencores.edifp.Port.invertDirection(direction);
	}
	
	public String toString() {		
		return "PORT"+dir[0]+" "+super.toString();
	}
	
	/** creates new (unlinked) node with same parameters.
	  * @return duplicated node */
	public Object clone() {
		NodePort n = new NodePort(INPUT);
		n.duplicate(this);
		return n;
	}
	
	/** duplicates parameters from n to this
	  * @param n node to copy data from */
	public void duplicate(NodePort n) {
		duplicate((Node)n);
	}
}
