/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.structure;

import org.opencores.Conf;

/** D-FF type class */
public class NodeFF extends Node {
	/** data */
	public final static int DATA = 0;
	/** clock */
	public final static int CLK = 1;
	/** async set */
	public final static int SET = 2;
	/** async reset */
	public final static int RST = 3;	
	/** output */
	public final static int OUT = 4;
	
	
  /** constructs new flip flop node */
	public NodeFF() {
		super (1+3+1); // D, C, S, R, O
		dir[OUT] = OUTPUT;
	}
	
	public String toString() {		
		return "FF "+super.toString();
	}
	
	/** creates new (unlinked) node with same parameters.
	  * @return duplicated node */
	public Object clone() {
		NodeFF n = new NodeFF();
		n.duplicate(this);
		return n;
	}
	
	/** duplicates parameters from n to this
	  * @param n node to copy data from */
	public void duplicate(NodeFF n) {
		duplicate((Node)n);
	}
}
